<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\UpdateAvailableDayTimeRequest;
use App\Http\Requests\Admin\StoreAvailableDayTimeRequest;
use App\Http\Controllers\Controller;
use App\Traits\Admin\AvailableDayTimeOperations;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\AvailableDayTime;
use Auth;

class DayTimeController extends Controller
{
    use AvailableDayTimeOperations;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
        // $this->middleware('Permission:engtime_show'    , ['only' => 'index', 'show']);
        // $this->middleware('Permission:engtime_add'     , ['only' => 'create', 'store']);
        // $this->middleware('Permission:engtime_edit'    , ['only' => 'edit', 'update']);
        // $this->middleware('Permission:engtime_delete'  , ['only' => 'destroy']);
    }
    public function index()
    {
        $times = AvailableDayTime::latest()->get();
        $title = 'مواعيد العمل';
        return view('admin.times.index', compact('times', 'title'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة ';
        
        return view('admin.times.add', compact('title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $time = $this->register($request);
        return redirect(url('/dashboard/times'))->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(AvailableDayTime $time)
    {
        $title = 'عرض ';
        return view('admin.times.show', compact('time', 'title'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $time = AvailableDayTime::find($id);
        
        $title = 'تعديل ';
        return view('admin.times.edit', compact('time', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $time)
    {
        // return $request->all();
        $time = AvailableDayTime::find($time);
        $this->UpdateRecords($time, $request);
        return redirect(url('/dashboard/times'))->with('success', 'data added successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(AvailableDayTime $time)
    {
        if ($time->image) {
            @unlink(public_path('/cdn/'.$time->image));
        }
        $time->delete();
        return 'success';
    }
}
