<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\FCMController;
use App\Notifications\GeneralNotification;
use App\Models\PlayerId;
use App\Models\User;
use App\Models\Driver;
use App\Http\Resources\CliUResource;
use App\Http\Resources\CliDResource;

class NotificationController extends Controller
{
    
    public function __construct()
    {
        $this->middleware('Permission:notofications'    , ['only' => 'index', 'store']);
    }
    public function index()
    {
    	$title = '';
    	return view('admin.notifications.add', compact('title'));
    }
    public function store(Request $request)
    {
    	$title = '';
    	$data = $request->all();
    	// send notification
            $title =$data['title'];
            $content = $data['content'];
            $type = "general";
            $title_ar = $title;
                $title_en = $title;
                $content_ar = $content;
                $content_en = $content;
                $activity = "general";
                $data2 = [
                    'title_ar' => $title_ar,
                    'title_en' => $title_en,
                    'content_ar' => $content_ar,
                    'content_en' => $content_en,
                    'type' => $type,
                ];
                if ($data['type'] == 'all') {
                    $token = PlayerId::pluck('player_id')->toArray();
                }elseif ($data['type'] == 'User') {
                    $token = PlayerId::where('taggable_type', 'LIKE', '%User%')->pluck('player_id')->toArray();
                }elseif ($data['type'] == 'Driver') {
                    $token = PlayerId::where('taggable_type', 'LIKE', '%Driver%')->pluck('player_id')->toArray();
                
                }elseif ($data['type'] == 'specific') {
                    $parm = $request->get('client_id');
                    if (strpos($parm, 'User') !== false) {
                        substr($parm, 4);
                        $token = PlayerId::where('taggable_type', 'LIKE', '%User%')->where('taggable_id', substr($parm, 3) )->pluck('player_id')->toArray();
                        
                    }elseif (strpos($parm, 'Driver') !== false) {
                        substr($parm, 6);
                        $token = PlayerId::where('taggable_type', 'LIKE', '%Driver%')->where('taggable_id', substr($parm, 5) )->pluck('player_id')->toArray();
                        
                    }
                    $token = PlayerId::where('taggable_type', 'LIKE', '%Driver%')->pluck('player_id')->toArray();
                }
                FCMController::Push($title, $content,$token,$data2, 'general');
            
            // send notification end
            return redirect()->back()->with('success', 'تم الارسال بنجاح');

    }
    public function cli(Request $request)
    {
        $data = $request->all();
        $users = User::where('name', 'LIKE', '%' . $request->get('q') . '%')->get();
        $users = CliUResource::collection($users);
        $drivers = Driver::where('name', 'LIKE', '%' . $request->get('q') . '%')->get();
        $drivers = CliDResource::collection($drivers);
        $users->merge($drivers);
        return response()->json($users);
    }
}
