<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\UpdateProductRequest;
use App\Http\Requests\Admin\StoreProductRequest;
use App\Http\Controllers\Controller;
use App\Traits\Admin\ProductOperations;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\Product;
use Auth;
use Excel;
use App\Exports\GeneralExport;
use Carbon\Carbon;

class ProductController extends Controller
{
    use ProductOperations;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    
    public function __construct()
    {
        $this->middleware('Permission:products_show'    , ['only' => 'index', 'show']);
        $this->middleware('Permission:products_add'     , ['only' => 'create', 'store']);
        $this->middleware('Permission:products_edit'    , ['only' => 'edit', 'update']);
        $this->middleware('Permission:products_delete'  , ['only' => 'destroy']);
    }
    public function index()
    {
        $title = 'المنتجات';
        if (in_array( auth('admin')->user()->role, ['branch', 'employee']) || (auth('admin')->user()->role == 'employee' && auth()->user()->parent_id != '0' )) {
            // 
            if (auth('admin')->user()->role == 'branch') {
                $branch_id = auth('admin')->id();
            } else {
                $branch_id = auth('admin')->user()->parent_id;
            }
                $products = Product::whereHas('BranchData', function($q) use( $branch_id ){
                    $q->where('admin_id', $branch_id);
                })->get();
            } else {
                $products = Product::latest();
                
            }
            $search = array();
            if (Request()->has('id') && Request()->get('id') != '') {
                $id = Request()->get('id');
                $search['id'] = $id;
                $products = $products->where('id',$id);
            }
            if (Request()->has('name') && Request()->get('name') != '') {
                $name = Request()->get('name');
                $search['name'] = $name;
                $products = $products->where('structure_no'     , 'LIKE', '%'.$name.'%')->orWhere('name'     , 'LIKE', '%'.$name.'%');
            }
            if (Request()->has('excel') && Request()->get('excel') != '') {
                $products = $products->get();
                return Excel::download(new GeneralExport($products, 'admin.reports.products-excel'), 'products-'.Carbon::now()->toDateString().'.xlsx');
            }
            $products = $products->paginate(40);
        return view('admin.products.index', compact('products', 'title' , 'search'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة ';
        return view('admin.products.add', compact('title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreProductRequest $request)
    {
        $this->register($request);
        return redirect('/dashboard/products')->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Product $product)
    {
        $title = 'عرض ';
        return view('admin.products.show', compact('product', 'title'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $product = Product::find($id);
        $title = 'تعديل ';
        return view('admin.products.edit', compact('product', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateProductRequest $request, $id)
    {
      
        $product = Product::find($id);
        $this->UpdateRecords($product, $request);
      
        return redirect('dashboard/products');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Product $product)
    {
        if ($product->form_image) {
            @unlink(public_path('/cdn/'.$product->form_image));
        }
        $product->delete();
        return 'success';
    }
}
