<?php

namespace App\Http\Requests\Api;

use Illuminate\Foundation\Http\FormRequest;
use App\Http\Requests\ApiFormRequest;

class UpdateUserRequest extends ApiFormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $user = auth('api')->user();
        return [
            'first_name'          => 'max:255',
            'last_name'          => 'max:255',
            'email'         => 'email|unique:users,email,'.$user->id.'|max:255',
            'phone'         => 'unique:users,phone,'.$user->id.'|max:255',
            'password'      => 'nullable|confirmed|max:255',
            // 'image'         => 'nullable|image',
        ];
    }
}
