<?php

namespace App\Http\Resources\Api;

use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon; 

class SingleOrderResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        ini_set('precision', 8);
        if(Request()->header('lang') == 'ar'){
            $lang = 'ar';
        }else{
            $lang = 'en';
        }
        return [
            'id'                        => $this->id,
            'car'                       => new CarResource($this->Car()->first()),
            'service'                   => new ServiceResource($this->Service()->first()),
            'total'                     => round($this->total, 2),
            'total_with_o_coupon_n_tax' => ((round($this->total, 2)  + $this->coupon_amount) / (100 + (float)getSettingValue('tax')) * 100),
            'original_total'            => round($this->original_total, 2),
            'discount'                  => round($this->discount,2),
            'status'                    => $this->status,
            'status_txt'                => getStatus($this->status, $lang),
            'start_time'                => $this->start_time,
            'rate'                      => round($this->rate, 2),
            'tax'                       => $this->tax,
            'phone'                     => $this->User->phone ?? '',
            'coupon'                    => $this->coupon,
            'coupon_amount'             => $this->coupon_amount,
            'service_price'             => $this->service_price,
            'payment_type'              => $this->payment_type,
            'latitude'                  => $this->latitude,
            'longitude'                 => $this->longitude,
            // 'added_val' => $this->total - ($this->original_total -$this->discount),
            'date'                      => Carbon::parse($this->day_date)->format('d M'),
            'time'                      => Carbon::parse($this->day_date. ' '.$this->start_time)->format('h:i A'),
            'items'                     => OrderItemResource::collection($this->OrderItem()->get()),
            'user'                      => new UserResource($this->User()->first()),
            'driver'                    => new DriverResource($this->Driver()->first()),
            'user_fcm_tokens'   => ( $this->User()->first() )? $this->User()->first()->PlayerId()->pluck('player_id')->toArray() : [],
            'driver_fcm_tokens' => ( $this->Driver()->first() )? $this->Driver()->first()->PlayerId()->pluck('player_id')->toArray() : [],
        ];
    }
}
