@extends('admin.layout.app')
@section('style')
<style>
    .text-muted {
        color: #000 !important;
    }

    .morris-hover.morris-default-style {
        position: absolute;
    }

</style>
@endsection
@section('content')
<div class="row">
    <div class="col-sm-12 m-b-15">
        <div class="btn-group pull-right m-t-15">
            <a href="/dashboard/drivers/{{$driver->id}}/edit" class="btn btn-info waves-effect w-md waves-light m-b-5">
                <i class="fa fa-pencil m-r-5"></i>
                <span>تعديل</span>
            </a>

            <a href="#" data-route="{{route('vacations.create')}}?id={{$driver->id}}"  data-toggle="modal" data-target="#vacation"
                class="load-ajax btn btn-info btn-danger waves-effect w-md waves-light m-b-5 m-l-5">
                <i class="fa fa-plus"></i>
                <span>اضافه اجازه</span>
            </a>
        </div>
        <h4 class="page-title">
            <i class="fa fa-home"></i>
            {{ $driver->name }}

        </h4>
    </div>
</div>
<!-- end row -->

<div class="row">
    <div class="col-lg-12">
        <div class="panel panel-color panel-tabs panel-success">
            <div class="panel-heading panel-heading-custom">
                <ul class="nav nav-pills">
                    <li class="active">
                        <a href="#navpills-1" data-toggle="tab" aria-expanded="true">البيانات الأساسية</a>
                    </li>
                    <li class="">
                        <a href="#navpills-2" data-toggle="tab" aria-expanded="false">الحجوزات</a>
                    </li>
                    <li class="">
                        <a href="#navpills-3" data-toggle="tab" aria-expanded="false">الاجازات</a>
                    </li>
                    <li class="">
                        <a href="#navpills-4" data-toggle="tab" aria-expanded="false">التصفيات</a>
                    </li>
                </ul>
            </div>
            <div class="panel-body">
                <div class="tab-content">
                    <div id="navpills-1" class="tab-pane fade in active">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="col-lg-4">
                                    <div class="card-box">
                                        <h4 class="header-title m-t-0"> مبيعات الخدمات</h4>
                                        <div id="morris-bar-example" style="height: 280px;"></div>
                                    </div>
                                </div><!-- end col -->
                            </div>
                            <div class="col-md-6">
                                <div class="col-lg-4">
                                    <div class="card-box">
                                        <h4 class="header-title m-t-0"> مبيعات المنتجات</h4>
                                        <div id="morris-bar-example2" style="height: 280px;"></div>
                                    </div>
                                </div><!-- end col -->
                            </div>
                            <div class="col-md-6">
                                <table class="table table-bordered table-striped text-center m-0">
                                    <thead>
                                        <tr style="    background-color: #fff;">
                                            <th colspan="2" class="text-center">
                                                <img src=" {{ $driver->image }}"
                                                    style="width: 100px; height: 100px;border-radius: 50%;border: 2px solid #2c0d0d;" />
                                            </th>
                                        </tr>
                                        <tr>
                                            <th class="text-center" colspan="4">البيانات الأساسية</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>الاسم</td>
                                            <td>{{$driver->name}}</td>
                                        </tr>
                                        <tr>
                                            <td>البريد الالكتروني</td>
                                            <td>{{$driver->email}}</td>
                                        </tr>
                                        <tr>
                                            <td>رقم الجوال</td>
                                            <td>{{$driver->phone}}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <table class="table table-bordered table-striped text-center m-0">
                                    <thead>
                                        <tr>
                                            <th class="text-center" colspan="4">الحسابات</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>اجمالي الفواتير الي الان</td>
                                            <td>{{$driver->OrderFinance()->where('active', '0')->whereHas('Order', function($q){$q->where('status', 'completed');})->sum('total_amount')}} ريال</td>
                                            {{-- <td>{{$driver->getOwedCompany() + $driver->getOwedDriver()}} ريال</td> --}}
                                        </tr>
                                        <tr>
                                            <td>اجمالي الخدمات الي الان</td>
                                            <td>{{$driver->getServiceTotal()}} ريال</td>
                                        </tr>
                                        <tr>
                                            <td>اجمالي ما تم تحصيله من السائق الي الان</td>
                                            <td>{{$driver->getTotalAmountCollectedByCompany()}} ريال</td>
                                        </tr>
                                        <tr>
                                            <td>اجمالي ما تم دفعه الي السائق الي الان</td>
                                            <td>{{$driver->getTotalAmountCollectedByDriver()}} ريال</td>
                                        </tr>
                                        <tr>
                                            <td>المستحق للشركة</td>
                                            <td>{{$driver->getOwedCompany()}} ريال</td>
                                        </tr>
                                        <tr>
                                            <td>المستحق للسائق</td>
                                            <td>{{$driver->getOwedDriver()}} ريال</td>
                                        </tr>
                                        @if ($last_finance)
                                            <tr>
                                                <td>تاريخ اخر تصفية </td>
                                                <td>{{$last_finance->created_at->toDateString()}}</td>
                                            </tr>
                                            
                                        @endif
                                        <tr>
                                            <td></td>
                                            <td>
                                                    <button class="btn btn-danger" data-toggle="modal" data-target="#exampleModal"> تصفيه الحسابات</button>
                                                
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>


                        </div>
                    </div>
                    <div id="navpills-2" class="tab-pane fade">

                        <div class="row">

                            <div class="col-sm-12">
                                <div class="card-box">
                                    <form action="" method="get">
                                        <div class="row">
                                            <div class="col-md-12 part-top">
                                                <div class="row">

                                                </div>
                                            </div>

                                            <div class="col-md-12">
                                                <div class="row">


                                                    <div class="col-lg-2">
                                                        <div class="form-horizontal">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <input type="text" name="user"
                                                                        value="{{(array_key_exists('user', $search))? $search['user'] : ''}}"
                                                                        class="form-control" placeholder=" اسم العميل">
                                                                </div>
                                                            </div>

                                                        </div>
                                                    </div>
                                                    <div class="col-lg-2">
                                                        <div class="form-horizontal">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <input type="text" name="id"
                                                                        value="{{(array_key_exists('id', $search))? $search['id'] : ''}}"
                                                                        class="form-control" placeholder="  رقم الحجز ">
                                                                </div>
                                                            </div>

                                                        </div>
                                                    </div>
                                                    <div class="col-lg-2">
                                                        <div class="form-horizontal">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <input type="text" name="date_from"
                                                                        value="{{(array_key_exists('date_from', $search))? $search['date_from'] : ''}}"
                                                                        class="form-control datepicker"
                                                                        autocomplete="off" placeholder="  التاريخ من">
                                                                </div>
                                                            </div>

                                                        </div>
                                                    </div>
                                                    <div class="col-lg-2">
                                                        <div class="form-horizontal">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <input type="text" name="date_to"
                                                                        value="{{(array_key_exists('date_to', $search))? $search['date_to'] : ''}}"
                                                                        class="form-control datepicker"
                                                                        autocomplete="off" placeholder="  التاريخ الي">
                                                                </div>
                                                            </div>

                                                        </div>
                                                    </div>



                                                    <div class="col-lg-2">
                                                        <div class="form-horizontal">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    {!! Form::select("status",array_merge(['' => 'اختر
                                                                    الحالة'],OrderStatus()),(array_key_exists('status',
                                                                    $search))?
                                                                    $search['status'] :
                                                                    null,['class'=>"form-control "])!!}
                                                                </div>
                                                            </div>

                                                        </div>
                                                    </div>


                                                    <div class="col-lg-1">
                                                        <button type="button"
                                                            onclick="$(this).closest('form').find('#excel').remove(); $(this).closest('form').submit();"
                                                            class="btn btn-block btn-sm btn-success waves-effect waves-light b-t-10 b-b-10"><i
                                                                class="fa fa-search"></i> بحث</button>
                                                    </div>

                                                    <div class="col-lg-1">
                                                        <div class="form-horizontal">
                                                            <a href="{{url('/dashboard/drivers/'.$driver->id)}}"
                                                                class="btn btn-block btn-sm btn-success waves-effect waves-light b-t-10 b-b-10"><i
                                                                    class="fa fa-trash"></i> مسح خيارات البحث</a>
                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <table class="table table-striped table-bordered">
                                    <thead>
                                        @php
                                        $i = 1;
                                        @endphp
                                        <tr>

                                            <th>#</th>
                                            <th>رقم الحجز </th>
                                            <th> اسم العميل </th>
                                            <th> رقم جوال العميل </th>
                                            {{--  <th>   مكان الحجز </th>  --}}
                                            <th> نوع الخدمة </th>
                                            <th> نوع السياره </th>
                                            <th> اسم السائق </th>
                                            <th> رقم جوال السائق </th>
                                            <th> تاريخ تنفيذ الحجز </th>
                                            <th> وقت البداية </th>
                                            <th> وقت الانتهاء </th>
                                            <th> الحاله </th>
                                            <th> المبلغ المستحق </th>
                                            {{--  <th>  وقت الحجز </th>
                                            <th> الخصم </th> --}}
                                            <th> طريقه الدفع </th>
                                            <th> تاريخ انشاء الحجز </th>
                                            <th> العمليات </th>


                                        </tr>
                                    </thead>

                                    <tbody>
                                        @foreach($orders as $item)

                                        <tr style="" id="id-{{$i}}">
                                            <td>{{$i++}} </td>
                                            <td>{{$item->id }} </td>
                                            <td>{{$item->User->name ?? ''}} </td>
                                            <td>{{$item->User->phone ?? ''}} </td>
                                            {{--  <td>{{$item->}} </td> --}}
                                            <td>{{$item->Service->name ?? ''}} </td>
                                            <td>{{$item->Car->name ?? ''}} </td>
                                            <td>{{$item->Driver->name ?? ''}} </td>
                                            <td>{{$item->Driver->phone ?? ''}} </td>
                                            <td>{{$item->day_date ?? ''}} </td>
                                            <td>{{$item->start_time ?? ''}} </td>
                                            <td>{{$item->end_time ?? ''}} </td>
                                            <td>{{getStatus($item->status, 'ar')}} </td>
                                            <td>{{$item->total}} </td>
                                            <td>{{$item->payment_type}} </td>
                                            <td>{{$item->created_at}} </td>


                                            <td class="btns">
                                                <a href="{{route('orders.destroy',$item)}}" type="button" title="حذف"
                                                    id="delete-btn"
                                                    class="btn btn-danger delete-btn  waves-effect waves-light m-b-5 btn-xs">
                                                    <i class="fa fa-times"></i> </a>
                                                <a href="/dashboard/orders/{{$item->id}}" type="button" title="عرض"
                                                    class="btn btn-info   waves-effect waves-light m-b-5 btn-xs"> <i
                                                        class="fa fa-eye"></i> </a>

                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                                {!! $orders->appends($search)->links() !!}
                            </div>
                        </div>
                    </div>
                    <div id="navpills-3" class="tab-pane fade">

                        <div class="row">

                            <div class="col-sm-12">
                                <div class="card-box">
                                    <form action="" method="get">
                                        <div class="row">
                                            <div class="col-md-12 part-top">
                                                <div class="row">

                                                </div>
                                            </div>

                                            <div class="col-md-12">
                                                <div class="row">


                                                    <div class="col-lg-2">
                                                        <div class="form-horizontal">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <input type="text" name="vacation_date"
                                                                        value="{{(array_key_exists('vacation_date', $search))? $search['vacation_date'] : ''}}"
                                                                        class="form-control" placeholder="تاريخ الاجازه">
                                                                </div>
                                                            </div>

                                                        </div>
                                                    </div>
                                                    <input type="hidden" name="vacation" value="1">
                                                    <div class="col-lg-1">
                                                        <button type="button"
                                                            onclick="$(this).closest('form').find('#excel').remove(); $(this).closest('form').submit();"
                                                            class="btn btn-block btn-sm btn-success waves-effect waves-light b-t-10 b-b-10"><i
                                                                class="fa fa-search"></i> بحث</button>
                                                    </div>

                                                    <div class="col-lg-1">
                                                        <div class="form-horizontal">
                                                            <a href="{{url('/dashboard/drivers/'.$driver->id)}}"
                                                                class="btn btn-block btn-sm btn-success waves-effect waves-light b-t-10 b-b-10"><i
                                                                    class="fa fa-trash"></i> مسح خيارات البحث</a>
                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            @foreach($vacations as $item)
                                <div class="col-md-3">
                                    <div class="container" style="border: 1px solid #00a69a; padding: 5px; border-radius: 5px;">
                                        <div class="col-sm-6">
                                            {{$item->day_date}}

                                        </div>
                                        <div class="col-sm-6">

                                            <a href="#" data-route="{{route('vacations.show', $item->id)}}?id={{$driver->id}}"  data-toggle="modal" data-target="#vacation"
                                                class="load-ajax btn btn-info">
                                                عرض 
                                            </a>
                                            
                                            <a href="{{route('vacations-delete', $item->id)}}" class="btn btn-danger">
                                                حذف 
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                            <div class="col-md-12">

                                {!! $vacations->appends($search)->links() !!}
                            </div>
                        </div>
                    </div>
                    <div id="navpills-4" class="tab-pane fade">

                        <div class="row">
                            
                            <div class="col-md-12">
                            <table class="table table-striped table-bordered">
                                <thead>
                                    @php
                                    $i = 1;
                                    @endphp
                                    <tr>
                                        <th> تم دفعه للسائق </th>
                                        <th> تم تحصيله من السائق </th>
                                        <th> تاريخ التصفية </th>


                                    </tr>
                                </thead>

                                <tbody>
                                    @foreach($finances as $item)

                                    <tr style="" id="id-{{$i}}">
                                        <td>{{$item->driver_amount }} ريال </td>
                                        <td>{{$item->company_amount }} ريال </td>
                                        <td>{{$item->created_at->toDateString() }} </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                            <div class="col-md-12">

                                {!! $finances->appends($search)->links() !!}
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div><!-- end col -->

</div>
<!-- end row -->
<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">اضافة الي حساب السائق</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">

                {!!Form::open( ['url' => route('drivers.finance', $driver->id) ,'method' => 'post','files' =>
                true,'id'=>'note-form']) !!}


                <div class="card-box">
                    <div class="row">


                        <p class="custom-label-centerd text-left">  </p>

                        <div class="col-lg-12">
                            <div class="form-group">
                                <label class=""> المبلغ الذي تم تحصيلة من السائق *</label>
                                <div class=" append">
                                    {!! Form::number('company_amount', null, ['class' => 'form-control', 'required' => '', 'placeholder' => 'المبلغ *', 'step'=> '.01']) !!}
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="form-group">
                                <label class=""> المبلغ الذي تم دفعه للسائق *</label>
                                <div class=" append">
                                    {!! Form::number('driver_amount', null, ['class' => 'form-control', 'required' => '', 'placeholder' => 'المبلغ *', 'step'=> '.01']) !!}
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="form-group">
                                <label class=""> الملاحظه *</label>
                                <div class=" append">
                                    {!! Form::textarea('notes', null, ['class' => 'form-control', 'required' => '', 'placeholder' => 'الملاحظه *']) !!}
                                </div>
                            </div>
                        </div>


                        <div class="text-center">
                            <button class="btn btn-primary waves-effect waves-light" type="submit"> حفظ
                            </button>
                        </div>
                    </div>


                </div>
                {!!Form::close() !!}
            </div>
            <div class="modal-footer">
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="vacation" tabindex="-1" role="dialog" aria-labelledby="vacationLabel"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="vacationLabel"> الاجازات</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body " id="ajax-content">

            </div>
            <div class="modal-footer">
            </div>
        </div>
    </div>
</div>

@endsection
@section('script')
<!--Morris Chart-->
<script src="/adminto/assets/plugins/morris/morris.min.js"></script>
<script src="/adminto/assets/plugins/raphael/raphael-min.js"></script>
<script>
    /**
    * Theme: Adminto Admin Template
    * Author: Coderthemes
    * Dashboard
    */

    ! function ($) {
        "use strict";

        var Dashboard1 = function () {
            this.$realData = []
        };

        //creates Bar chart
        Dashboard1.prototype.createBarChart = function (element, data, xkey, ykeys, labels, lineColors) {
                Morris.Bar({
                    element: element,
                    data: data,
                    xkey: xkey,
                    ykeys: ykeys,
                    labels: labels,
                    hideHover: 'auto',
                    resize: true, //defaulted to true
                    gridLineColor: '#eeeeee',
                    barSizeRatio: 0.2,
                    barColors: lineColors
                });
            },

            //creates line chart
            Dashboard1.prototype.createLineChart = function (element, data, xkey, ykeys, labels, opacity, Pfillcolor,
                Pstockcolor, lineColors) {
                Morris.Line({
                    element: element,
                    data: data,
                    xkey: xkey,
                    ykeys: ykeys,
                    labels: labels,
                    fillOpacity: opacity,
                    pointFillColors: Pfillcolor,
                    pointStrokeColors: Pstockcolor,
                    behaveLikeLine: true,
                    gridLineColor: '#eef0f2',
                    hideHover: 'auto',
                    resize: true, //defaulted to true
                    pointSize: 0,
                    lineColors: lineColors
                });
            },

            //creates Donut chart
            Dashboard1.prototype.createDonutChart = function (element, data, colors) {
                Morris.Donut({
                    element: element,
                    data: data,
                    resize: true, //defaulted to true
                    colors: colors
                });
            },


            Dashboard1.prototype.init = function () {

                //creating bar chart
                var $barData = JSON.parse('{!! $services_chart !!}');
                this.createBarChart('morris-bar-example', $barData, 'y', ['a'], ['العدد'], ['#188ae2']);
                //creating bar chart
                var $barData2 = JSON.parse('{!! $prods_chart !!}');
                this.createBarChart('morris-bar-example2', $barData2, 'y', ['a'], ['العدد'], ['#188ae2']);

                //create line charthart
            },
            //init
            $.Dashboard1 = new Dashboard1, $.Dashboard1.Constructor = Dashboard1
    }(window.jQuery),

    //initializing 
    function ($) {
        "use strict";
        $.Dashboard1.init();
    }(window.jQuery);

</script>
@endsection
