<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});


Route::get('/dd/{id}', function ($id) {
    return \App\Models\Driver::whereId($id)->first()->getOwedDriver();
    return view('welcome');
});

Auth::routes();

Route::get('/home', 'HomeController@index')->name('home');




Route::group(['namespace' =>'Admin'], function() {
    Route::get('/admin/login','AuthController@loginForm')->name('login');
    Route::post('/admin/login','AuthController@login');
    Route::group(['prefix' => 'dashboard', 'middleware' => 'auth:admin'], function() {
        Route::get('/', 'HomeController@index')->name('dashboard.main');
        Route::resource('/users', 'UserController');
        Route::resource('/orders', 'OrderController');
        Route::get('/orders-items/create', 'OrderController@Itemcreate')->name('orders-items.create');
        Route::post('/orders-items/store', 'OrderController@Itemstore')->name('orders-items.store');
        Route::get('/orders-items/edit/{id}', 'OrderController@Itemedit')->name('orders-items.edit');
        Route::patch('/orders-items/{id}', 'OrderController@Itemupdate')->name('orders-items.update');
        Route::delete('/orders-items/destroy/{id}', 'OrderController@Itemdestroy')->name('orders-items.destroy');
        Route::resource('/cars', 'CarController');
        Route::resource('/colors', 'ColorController');
        Route::resource('/cities', 'CityController');
        Route::resource('/zones', 'ZoneController');
        Route::get('/cities-c-p/{id}/{lat}/{long}', 'CityController@checkP');
        Route::get('/get-times', 'OrderController@GTimes')->name('get-times');
        Route::post('/get-times', 'OrderController@GTimesPost');
        Route::resource('/brands', 'BrandController');
        Route::resource('/brand-models', 'BrandModelController');
        Route::resource('/drivers', 'DriverController');
        Route::post('/drivers-finance/{id}', 'DriverController@finance')->name('drivers.finance');
        Route::resource('/coupons', 'CouponController');
        Route::resource('/products', 'ProductController');
        Route::resource('/services', 'ServiceController');
        Route::resource('/shifts', 'ShiftController');
        Route::resource('/admins', 'AdminController');
        Route::resource('/pricelists', 'PriceListController');
        Route::resource('/vacations', 'VacationController');
        Route::get('/vacations-delete/{id}', 'VacationController@destroy')->name('vacations-delete');
        Route::resource('/times', 'DayTimeController');
        Route::resource('/notifications', 'NotificationController')->only(['index', 'store']);
        Route::get('/notifications-cli', 'NotificationController@cli')->name('noti-cli');
        Route::resource('/feedback', 'FeedbackController')->only(['index']);
        Route::get('/get-regions/{id}', 'SettingsController@regions');

            Route::get('/permissions', 'SettingsController@PermissionGet');
            Route::post('/permissions', 'SettingsController@PermissionPost');
            Route::post('/permissions-update/{id}', 'SettingsController@PermissionUpdate');
            Route::delete('/permissions-delete/{id}', 'SettingsController@PermissionDelete');
            Route::delete('/user-permissions-delete/{id}', 'SettingsController@PermissionDeleteUser');
            Route::post('/user-role', 'SettingsController@UserRole');
        Route::group(['prefix' => 'settings'], function() {
            Route::get('/site', 'SettingController@index');
            Route::post('/site', 'SettingController@store');
            Route::get('/payment', 'SettingController@payment');
            Route::post('/payment', 'SettingController@store');
            Route::get('/brands', 'SettingController@indexBrand');
            Route::post('/brands', 'SettingController@store');
            Route::get('/admins-edit/{id}', 'SettingsController@AdminEdit');
            Route::post('/admins-edit/{id}', 'SettingsController@AdminUpdate');
            Route::post('/admins-update/{id}', 'SettingsController@AdminUpdate');

        });

        Route::group(['prefix' => 'reports'], function() {
            Route::get('/drivers', 'ReportController@DriversView')->name('reports.drivers');
            Route::post('/drivers', 'ReportController@Drivers');
            Route::get('/drivers-orders', 'ReportController@DriversOrderView')->name('reports.drivers-orders');
            Route::post('/drivers-orders', 'ReportController@DriversOrder');
            Route::get('/cities-orders', 'ReportController@CitiesOrderView')->name('reports.cities-orders');
            Route::post('/cities-orders', 'ReportController@CitiesOrder');
        });
    });
});
