<?php

use Carbon\Carbon;

function getSettingValue($key)
{
    $row = \App\Models\Setting::where('key', $key)->first();
    if ($row) {
        return $row->value;
    }
    return '';
}

function priceWithVat($price)
{
    $tax = (float)getSettingValue('tax');
    return $price / 100 * $tax;
}

function uploadFile($request)
{
    $filename = rand(99999, 99999999) . time(). '.' . $request->file('image')->getClientOriginalExtension();
    $request->file('image')->move(public_path('/cdn'), $filename);
    // $profileimg  = $filename;
    return $filename;
}

function uploadImage($file)
{
    $filename = rand(99999, 99999999) . time(). '.' . $file->getClientOriginalExtension();
    $file->move(public_path('/cdn'), $filename);
    // $profileimg  = $filename;
    return $filename;
}

function FileHtmlContent($file)
{
    // return $file;
    try{
        if(strpos($file, url('/')) !== false) {
            $file = str_replace( url('/'). '/cdn/', '', $file);
        }
        $file2 = public_path('/cdn/'.$file);
        $type = exif_imagetype($file2);
        switch($type) {
          case IMG_GIF:
            $type = 'image/gif';
            break;
          case IMG_JPG:
            $type = 'image/jpg';
            break;
          case IMG_JPEG:
            $type = 'image/jpeg';
            break;
          case IMG_PNG:
            $type = 'image/png';
            break;
          case IMG_WBMP:
            $type = 'image/wbmp';
            break;
          case IMG_XPM:
            $type = 'image/xpm';
            break;
          default:
            $type = 'unknown';
        }

    }catch(\Exception $e){
        return '';
    }
    $file = GetImage($file);
    if(    str_contains($type, 'image')    )
    {
        $type = 'image';
    }
    switch ($type) {
        case 'image':
            return '<img src="'.$file.'" class="image-responsive" style="height:150px; width:100%;" />';
            break;

        default:
            return '<center><a href="'.$file.'"><i class="fa fa-file-text" aria-hidden="true" style=font-size:124px;></i>
</a></center>';
            break;
    }
}

function uploadImageBase64($file)
{

    // $filename = rand(99999, 99999999) . time(). '.' . $file->getClientOriginalExtension();
    $image = $file;  // your base64 encoded
    $image = str_replace('data:image/png;base64,', '', $image);
    $image = str_replace(' ', '+', $image);
    // $filename = str_random(10).'.'.'png';
   $filename = 'image_'.rand(99999, 99999999) .time().'.png'; //generating unique file name;
   @list($type, $file_data) = explode(';', $image);
   @list(, $image) = explode(',', $image);
    \File::put(public_path(). '/cdn/' . $filename, base64_decode($image));
    // $profileimg  = $filename;
    // $filename = rand(99999, 99999999) . $file->getClientOriginalName();
    // $file->move(public_path('/cdn'), $filename);
    // $profileimg  = $filename;
    return $filename;
}

function getImage($filename)
{
    if(strpos($filename, url('/')) !== false) {
        return $filename;
    }
    return url('/').'/cdn/'.$filename;
}

function Sizes()
{
    $arr = [
        'small' => 'صغيرة',
        'large' => 'كبيرة',
    ];
    return $arr;
}

function Days()
{
    $arr = [
        'sat' => 'sat',
        'sun' => 'sun',
    ];
    return $arr;
}

function AccountActive()
{
    $arr = [
        '1' => 'مفعل',
        '0' => 'غير مفعل',
    ];
    return $arr;
}

function payment_account_type()
{
    $arr = [
        'test' => 'Sandbox',
        'live' => 'Live',
    ];
    return $arr;
}

function Payments()
{
    $arr = [
        'cash' => 'كاش',
        'online' => 'دفع الكتروني',
    ];
    return $arr;
}

function DriverReviewed()
{
    $arr = [
        '0' => ' لم تتم المراجعه',
        '1' => 'تمت المراجعه',
    ];
    return $arr;
}

function OrderTypes()
{
    $arr = [
        'internal' => 'داخلي',
        'external' => 'خارجي',
    ];
    return $arr;
}

function Driver()
{
     $cats = \App\Models\Driver::get();
    $arr = [''=> 'اختر السائق'];
    foreach ($cats as $item) {
        $arr[$item->id] = $item->name;

    }
    return $arr;
}

function TheCity($title = 'اختر المدينه')
{
    $cats = \App\Models\City::get();
    $arr = [''=> $title];
    foreach ($cats as $item) {
        $arr[$item->id] = $item->name;

    }
    return $arr;

}
function User()
{
    $cats = \App\Models\User::get();
    $arr = [''];
    foreach ($cats as $item) {
        $arr[$item->id] = $item->name;

    }
    return $arr;

}
function Shifts()
{
    $cats = \App\Models\Shift::get();
    $arr = ['' => 'اختر'];
    foreach ($cats as $item) {
        $arr[$item->id] = $item->start_time . ' : ' . $item->end_time;

    }
    return $arr;

}

function DriverType()
{
    $arr = [
        'employee' => 'موظف',
        'not_employee' => 'غير موظف',
    ];
    return $arr;
}
function UserRole()
{
    $arr = [
        'user' => 'مستخدم',
        'admin' => 'مدير',
        // 'company' => 'شركة',
    ];
    return $arr;
}
function ProductType()
{
    $arr = [
        'rent' => 'ايجار',
        'sale' => 'بيع',
    ];
    return $arr;
}

function GetCount($table,$column, $value, $operator = '=')
{
    if ($column != '') {
        //
        return \DB::table($table)->where($column, $operator, $value)->count();
    }else{
        return \DB::table($table)->count();
    }
}
function Admins()
{
    $cats = \App\Models\Admin::get();
    $arr = [];
    $arr[''] = 'اختر المستخدم';
    foreach ($cats as $item) {
            $arr[$item->id] = $item->name;
    }
    return $arr;
}
function RolesList()
{
    $cats = \App\Models\Role::get();
    $arr = [];
    foreach ($cats as $item) {
            $arr[$item->id] = $item->name;
    }
    return $arr;
}
function CheckPermission($key)
{
    if(auth()->user()->role == 'admin' )
    {
        return true;
    }
    $role = auth()->user()->UserRole()->first();
    if( $role )
    {
        $permission = $role->Role()->first()->Permission()->where('permission', $key)->first();
        if ($permission) {
            return true;
        }
    }
    return false;
}

function AllCity()
{
    return $cats = \App\Models\City::get();
    $arr = [];
    foreach ($cats as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $arr;
}

function AllColors()
{
    $cats = \App\Models\Color::get();
    $arr = [];
    foreach ($cats as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $arr;
}
function Services()
{
    $cats = \App\Models\Service::get();
    $arr = ['' => 'اختر
    الخدمة'];
    foreach ($cats as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $arr;
}
function Products()
{
    $cats = \App\Models\Product::get();
    $arr = ['' => 'اختر المنتج'];
    foreach ($cats as $item) {
        $arr[$item->id] = $item->name;

    }
    return $arr;
}
function Users()
{
    $items = \App\Models\User::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name . ' ' . $item->phone;

    }
    return $arr;
}

function AllYears()
{
    return $items = \App\Models\Year::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $arr;
}

function CitiesP()
{
    $items = \App\Models\City::where('parent', '0')->OrWhereHas('Parent', function($q){$q->where('parent', '0');})->get();
    $arr = ['0' => ' - '];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;
    }
    return $arr;
}
function CitiesPP()
{
    $items = \App\Models\City::where('parent', '0')->get();
    $arr = [];
    $arr = ['' => 'اختر المدينة '];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;
    }
    return $arr;
}

function Zones()
{
    $items = \App\Models\Zone::get();
    foreach ($items as $item) {
        $arr[$item->id] = $item->name;

    }
    return $arr;
}

function Cities()
{
    $items = \App\Models\City::get();
    $arr = ['' => 'اختر'];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $arr;
}
function Cars()
{
    $items = \App\Models\Car::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name;

    }
    return $arr;
}

function AllCarTypes()
{
    return $cats = \App\Models\CarType::get();
}

function AllCarCarrierTypes()
{
    return $cats = \App\Models\CarCarrierType::get();
}

function AllCarMakers()
{
    return $cats = \App\Models\CarMaker::get();
}

function AllPriceLists()
{
    return $cats = \App\Models\PriceList::get();
}

function AllCarModels()
{
    return $cats = \App\Models\CarModel::get();
}

function CarMakersList()
{
    $items = \App\Models\CarMaker::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $arr;
}

function CarTypeList()
{
    $items = \App\Models\CarType::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $arr;
}

function CarCarrierTypeList()
{
    $items = \App\Models\CarCarrierType::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $arr;
}

function CarModelList()
{
    $items = \App\Models\CarModel::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $arr;
}

function CarColorList()
{
    $items = \App\Models\Color::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $arr;
}

function CarYearList()
{
    $items = \App\Models\Year::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name;

    }
    return $arr;
}
function Brand()
{
    $items = \App\Models\Brand::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $arr;
}
function Drivers($title = '')
{
    $items = \App\Models\Driver::/*whereDoesntHave('Vacation', function($q){
        $q->whereDate('day_date', Carbon::today()->toDateString());
    })->*/get();
    $arr = ['' => $title];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name;
    }
    return $arr;
}

function OrdersList($id)
{
    if ($id == '') {
        $items = \App\Models\Order::where('trip_id', null)->get();
    }else{
        $items = \App\Models\Order::where('trip_id', null)->orWhere('trip_id', $id)->get();

    }
    $items = \App\Models\Order::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = 'حجز رقم #' . $item->id;

    }
    return $arr;
}
function getStatus($key = '', $lang = 'ar')
{
    $arr = [
        'init' => 'Order Placed On',
        'pending' => 'Order Placed On',
        'driver_on_the_way' => 'Driver on the way',
        'washing_car' => 'Washing Car ',
        'completed' => 'Order Completed ',
        'canceled' => 'Order canceled ',
    ];
    $arrAr = [
        'init' => 'انشاء الحجز',
        'pending' => 'انشاء الحجز',
        'driver_on_the_way' => 'البايكر في الطريق اليك',
        'washing_car' => 'جاري غسيل السياره',
        'completed' => 'تم اكتمال الحجز',
        'canceled' => 'تم الالغاء',
    ];
    if ($key != '') {

        if (array_key_exists($key,$arr)) {
            if ($lang == 'ar') {
                return $arrAr[$key];

            }
            return $arr[$key];
        }
        return 'init';
    }
    return $arr;
}
function OrderStatus($key = '', $lang = 'ar')
{
    $arr1 = [];
    if ($key != '') {
        $arr1 = ['' => $key];
    }
    $arr = [
        'pending' => ' حجز جديد',
        'driver_on_the_way' => 'في الطريق السائق ',
        'washing_car' => 'جاري غسيل السياره',
        'completed' => 'تم اكتمال الحجز',
        'canceled' => 'تم الالغاء',
    ];
    return array_merge($arr1,$arr);
}
function scolors($k)
{

    $arr = [
        'pending' => '#dddddd',
        'driver_on_the_way' => '#f9c851',
        'washing_car' => '#ff8acc',
        'completed' => '#10c469',
        'canceled' => '#ff5b5b',
    ];
    return $arr[$k];
}
function Gender()
{
    $arr = [
        'male' => 'ذكر',
        'female' => 'انثي',
    ];
    return $arr;
}
function TripStatus()
{
    $arr = [
        'init' => 'جديد',
        'confirmed' => 'تم التاكيد و الدفع',
        'processing' => 'جاري المعالجة',
        'in_source_branch' => 'في فرع الاستلام',
        'in_destination_branch' => 'في فرع التسليم',
        'canceled' => 'تم الالغاء',
        'finished' => 'تم الانتهاء',
    ];
    return $arr;
}

function DriversList()
{
    $items = \App\Models\Driver::get();
    $arr = ['' => 'اختر السائق'];
    foreach ($items as $item) {
        $arr[$item->id] = ($item->type == 'not_employee')? $item->name . "  (خارجي)" : $item->name . "  (داخلي)";

    }
    return $arr;
}

function OrderStatusAr($key)
{
    $arr = [
        '' => 'لم يتم الدفع',
        'init' => 'لم يتم الدفع',
        'confirmed' => 'تم التاكيد و الدفع',
        'processing' => 'جاري المعالجة',
        'in_source_branch' => 'في فرع الاستلام',
        'in_destination_branch' => 'في فرع التسليم',
        'canceled' => 'تم الالغاء',
        'finished' => 'تم الانتهاء',
        'cannot_receive' => 'لم يتم التسليم',
    ];
    if (array_key_exists($key,$arr)) {
        return $arr[$key];
    }
    return 'init';
}

function OrderStatusEn($key)
{
    $arr = [
        '' => 'payment Failed',
        'init' => 'payment Failed',
        'confirmed' => 'Confirmed',
        'processing' => 'Processing',
        'in_source_branch' => 'in Source Branch',
        'in_destination_branch' => 'In Destination Branch',
        'canceled' => 'Canceled',
        'finished' => 'Finished',
        'recieved' => 'Recieved',
        'shipping' => 'Shipping',
        'cannot_receive' => 'Not Recieved',
    ];
    if (array_key_exists($key,$arr)) {
        return $arr[$key];
    }
    return 'init';
}
function PermissionModels()
{
    return [ 'users', 'orders', 'services', 'products', 'cars', 'drivers', 'coupons'];
}
function Roles()
{
    $cats = \App\Models\Role::get();
    $arr = [];
    foreach ($cats as $item) {
            $arr[$item->id] = $item->name;
    }
    return $cats;
}
// shimaa///////////////////////
function Years()
{
   $items = \App\Models\Year::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name;

    }
    return $arr;
}

function Models()
{
   $items = \App\Models\Models::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $arr;
}
function ModelsList()
{
   $items = \App\Models\Models::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $arr;
}
function AllModels()
{
   $items = \App\Models\Models::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $items;
}
function Missions()
{
   $items = \App\Models\Mission::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $items;
}
function MissionsList()
{
   $items = \App\Models\Mission::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $arr;
}
function Categories()
{
   $items = \App\Models\Category::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $items;
}
function CategoriesList()
{
   $items = \App\Models\Category::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $arr;
}
function Branchs()
{
   $items = \App\Models\Branch::get();
    $arr = [];
    foreach ($items as $item) {
        $arr[$item->id] = $item->name_ar;

    }
    return $arr;
}

?>
