<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Subscribe extends Model
{
    protected $table='subscribes';
    protected $fillable = [
        'user_id' , 'service_id' , 'cleans' , 'original_total', 'discount', 'total_price', 'image', 'coupon',
        'price', 'coupon_amount', 'tax'
    ];

    public function SubscribeItem()
    {
        return $this->hasMany(SubscribeItem::class, 'subscribe_id');
    }
    public function Service()
    {
        return $this->belongsTo(Service::class, 'service_id');
    }
    public function User()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
