<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Tymon\JWTAuth\Contracts\JWTSubject;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;


class User extends Authenticatable implements JWTSubject
{
    use Notifiable;

    protected $table='users';
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'first_name', 'last_name', 'password', 'email' , 'phone' ,'city_id' , 'verify_code', 'lang', 'image', 'active', 'name', 'gender'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
// Rest omitted for brevity

    /**
     * Get the identifier that will be stored in the subject claim of the JWT.
     *
     * @return mixed
     */
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [];
    }
    /**
     * Get all of the post's Files.
     */
    public function PlayerId()
    {
        return $this->morphMany(PlayerId::class, 'taggable');
    }
    public function City()
    {
        return $this->belongsTo(City::class, 'city_id');
    }
    public function Order()
    {
        return $this->HasMany(Order::class, 'user_id');
    }
    public function Car()
    {
        return $this->HasMany(Car::class, 'user_id');
    }
    public function getImageAttribute($img)
    {
        if($img)
        {
            return url('/').'/cdn/'.$img;
        }
        return $img;

    }
    
    public function Address()
    {
        return $this->Hasmany(Address::class, 'user_id');
    }
    public function Card()
    {
        return $this->Hasmany(Card::class, 'user_id');
    }
}
