@extends('admin.layout.app')
@section('style')
<style>
    table {
        border-collapse: collapse;
        border: 1px solid black;
    }


    td,
    th {

        text-align: right;
        padding: 7px;
        border-bottom: 1px solid black;
    }

    .qrcode div {
        margin: auto;
    }

    @media print {
        .xc {
            text-align: left !important;
            border: 1px solid #000 !important;
            background-color: #000 !important;
            color: #fff !important;
            width: 2rem !important;
        }
    }

</style>
@endsection
@section('header')
<li>
</li>
@endsection
@section('content')
<div class="card-box">

    <div class="row">

        <div class="col-md-6">
            <div class="col-md-12 text-center" style="">
                <h3> تفاصيل الحجز </h3>
            </div>
            <table class="table table-striped" style="  border: 1px solid gray;">
                <thead>

                <tbody>
                    <tr>
                        <th scope="row" style="  border: 1px solid gray;  color:#000;"> #</th>
                        <td style="  border: 1px solid gray;">{{$subscribe->id ?? ''}}</td>
                    </tr>
                    <tr>
                        <th scope="row" style="  border: 1px solid gray;  color:#000;">اسم العميل</th>
                        <td style="  border: 1px solid gray;">{{$subscribe->User->name ?? ''}}</td>
                    </tr>
                    <tr>
                        <th scope="row" style="  border: 1px solid gray;  color:#000;"> السعر الكلي </th>
                        <td style="  border: 1px solid gray;">{{$subscribe->total_price}} ريال</td>

                    </tr>

                    @if ($subscribe->coupon)

                    <tr>
                        <th scope="row" style="  border: 1px solid gray; color:#000;"> كوبون  </th>
                        <td style="  border: 1px solid gray;">{{$subscribe->coupon}}</td>

                    </tr>


                    @endif
                    <tr>
                        <th scope="row" style="  border: 1px solid gray; color:#000;"> الخدمة </th>
                        <td style="  border: 1px solid gray;">{{$subscribe->Service->name ?? ''}}</td>

                    </tr>
                    @if ($subscribe->image)

                    <tr>
                        <th scope="row" style="  border: 1px solid gray; color:#000;"> الصورة  </th>
                        <td style="  border: 1px solid gray;">
                        <img src="{{getImage($subscribe->image)}}" width="150" height="150" alt="" srcset="">
                        </td>

                    </tr>


                    @endif

                </tbody>
            </table>
        </div>



        {{--  'name', 'email', 'password', 'phone' , 'role' , 'image' , 'latitude' , 'longitude' , 'address' ,
        'verified', 'code' , 'social_id', 'social_type', 'branch_id' , 'status'  --}}

        <div class="col-md-6">
            <div class="col-md-12 text-center" style="">
                <h3> تفاصيل العميل </h3>
            </div>
            <table class="table table-striped" style="  border: 1px solid gray;">
                <thead>

                <tbody>
                    <tr style="  border: 1px solid gray;">
                        <th scope="row" style="  border: 1px solid gray; color:#000;">اسم العميل</th>
                        <td style="  border: 1px solid gray;">{{$subscribe->User->name ?? ''}}</td>

                    </tr>

                    <tr>
                        <th scope="row" style="  border: 1px solid gray; color:#000;">البريد الالكترونى</th>
                        <td style="  border: 1px solid gray;">{{$subscribe->User->email ?? ''}}</td>

                    </tr>
                    <tr>
                        <th scope="row" style="  border: 1px solid gray; color:#000;"> رقم الجوال</th>
                        <td style="  border: 1px solid gray;">{{$subscribe->User->phone?? ''}}</td>

                    </tr>



                </tbody>
            </table>

        </div>


    </div>
    {{--  'title_ar', 'title_en', 'description_ar' , 'description_en' , 'price', 'image' , 'active' , 'new_price',
    'category_id', 'sku' , 'status'  --}}
    <div class="row">
        <div class="col-md-12">
            <div class="col-md-12 text-center" style="">
                <h3> المنتجات </h3>
            </div>
            <table class="table table-striped" style="  border: 1px solid gray;">
                <thead>
                    <thead>
                        <tr>
                            <th> الصورة</th>
                            <th>العنوان </th>
                            <th> السعر </th>
                            <th> الكميه </th>
                            <th> الاجمالي </th>

                        </tr>

                    </thead>
                <tbody>
                    @foreach ($subscribe->SubscribeItem()->get() as $item)

                    <tr>
                        <td style="  border: 1px solid gray; color:#000;">
                            <img style="height: 100px; width: 100px" src="{{$item->Product->image ?? ''}}" />
                        </td>
                        <td style="  border: 1px solid gray; color:#000;">{{$item->Product->name ?? ''}}</td>
                        <td style="  border: 1px solid gray; color:#000;">{{$item->price ?? ''}} ريال</td>
                        <td style="  border: 1px solid gray; color:#000;">{{$item->qty}}</td>
                        <td style="  border: 1px solid gray; color:#000;">{{$item->qty * $item->price}} ريال</td>

                    </tr>
                    @endforeach

                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection

@section('script')
<script type="text/javascript"
    src="https://maps.google.com/maps/api/js?sensor=false&libraries=places&key=AIzaSyCob-v1r_8bpOUPIm4TiaxrD3roc_XLFFo&language=ar">
</script>
<script>
    function initMap() {
      const myLatLng = { lat: parseFloat('{{$subscribe->latitude}}'), lng: parseFloat('{{$subscribe->longitude}}') };
      const map = new google.maps.Map(document.getElementById("map"), {
        zoom: 12,
        center: myLatLng,
      });
      new google.maps.Marker({
        position: myLatLng,
        map,
        title: "Hello World!",
      });
    }
    initMap();
  </script>
@endsection
