<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Resources\Api\CarResource;

class CarController extends Controller
{
    public function index()
    {
        $user = auth('api')->user();
        $cars = $user->Car()->get();
        $cars = CarResource::collection($cars);
        return Response()->json([
            'data'          => ['cars' => $cars],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }
    public function store(Request $request)
    {
        $user = auth('api')->user();
        $data= $request->all();
        if ($request->hasFile('image')) {
            $data['image'] = uploadFile($request);
        }
        $user->Car()->create( $data );
        $cars = $user->Car()->get();
        $cars = CarResource::collection($cars);
        return Response()->json([
            'data'          => ['cars' => $cars],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }
    public function update(Request $request)
    {
        $user = auth('api')->user();
        $data= $request->except('car_id');
        if ($request->hasFile('image')) {
            $data['image'] = uploadFile($request);
        }
        $user->Car()->where('id', $request->car_id)->update( $data );
        $cars = $user->Car()->get();
        $cars = CarResource::collection($cars);
        return Response()->json([
            'data'          => ['cars' => $cars],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }
    public function destroy(Request $request)
    {
        $user = auth('api')->user();
        $user->Car()->where('id', $request->car_id)->delete();
        $cars = $user->Car()->get();
        $cars = CarResource::collection($cars);
        return Response()->json([
            'data'          => ['cars' => $cars],
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }
}
