<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Traits\Admin\ShiftOperations;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\Shift;
use Auth;

class ShiftController extends Controller
{
    use ShiftOperations;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    
    public function __construct()
    {
        $this->middleware('Permission:shifts_show'    , ['only' => 'index', 'show']);
        $this->middleware('Permission:shifts_add'     , ['only' => 'create', 'store']);
        $this->middleware('Permission:shifts_edit'    , ['only' => 'edit', 'update']);
        $this->middleware('Permission:shifts_delete'  , ['only' => 'destroy']);
    }
    public function index()
    {
        $shifts = Shift::latest()->get();
        $title = 'شيفتات العمل';
        return view('admin.shifts.index', compact('shifts', 'title'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة شيفت';
        $code = \Str::random(6);
        return view('admin.shifts.add', compact('title', 'code'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->register($request);
        return redirect('/dashboard/shifts')->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Shift $shift)
    {
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $shift = Shift::find($id);
        $title = 'تعديل شيفت';
        return view('admin.shifts.edit', compact('shift', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Shift $Shift)
    {
        // $Shift = Shift::find($id);
        $this->UpdateRecords($Shift, $request);
        return redirect('/dashboard/shifts')->with('success', 'data added successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Shift $Shift)
    {
        if ($Shift->image) {
            @unlink(public_path('/cdn/'.$Shift->image));
        }
        $Shift->delete();
        return 'success';
    }
}
