<?php

namespace App\Http\Resources\Api;

use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon; 

class OrderResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'                => $this->id,
            'car'               => new CarResource($this->Car()->first()),
            'total'             => $this->total,
            'rate'              => $this->rate,
            'status'            => $this->status,
            'phone'             => $this->User->phone ?? '',
            'address'           => $this->address,
            'latitude'          => $this->latitude,
            'longitude'         => $this->longitude,
            'date'              => Carbon::parse($this->day_date)->format('d M'),
            'time'              => Carbon::parse($this->day_date. ' '.$this->start_time)->format('h:i A'),
            'user'              => new UserResource($this->User()->first()),
            'driver'            => new DriverResource($this->Driver()->first()),
            'user_fcm_tokens'   => ( $this->User()->first() )? $this->User()->first()->PlayerId()->pluck('player_id')->toArray() : [],
            'driver_fcm_tokens' => ( $this->Driver()->first() )? $this->Driver()->first()->PlayerId()->pluck('player_id')->toArray() : [],
        ];
    }
}
