<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Driver;
use App\Models\Order;
use Excel;
use App\Exports\GeneralExport;
use Carbon\Carbon;

class ReportController extends Controller
{
    public function Drivers(Request $request)
    {
        $drivers = Driver::latest();


        $search = array();
        if (Request()->has('id') && Request()->get('id') != '') {
            $id = Request()->get('id');
            $search['id'] = $id;
            $drivers = $drivers->where('id'     ,$id);
        }
        if (Request()->has('phone') && Request()->get('phone') != '') {
            $phone = Request()->get('phone');
            $search['phone'] = $phone;
            $drivers = $drivers->where('phone'     , 'LIKE', '%'.$phone.'%');
        }

        $drivers = $drivers->get();

        return Excel::download(new GeneralExport($drivers, 'admin.reports.driver-excel'), 'drivers-'.Carbon::now()->toDateString().'.xlsx');
    }
    public function DriversView(Request $request)
    {
        $search = array();
        $title = "تقرير سائقين";
        return view('admin.reports.drivers', compact('search', 'title'));
    }
    public function DriversOrderView(Request $request)
    {
        $search = array();
        $title = "تقرير عمل السائقين";
        return view('admin.reports.orders', compact('search', 'title'));
    }
    public function DriversOrder(Request $request)
    {

        $orders = Order::where('status', '<>', 'canceled')->latest();
        $driver = null;
        $search = array();
        if (Request()->has('user_id') && Request()->get('user_id') != '') {
            $user_id = Request()->get('user_id');
            $search['user_id'] = $user_id;
            $orders = $orders->where('user_id'  ,$user_id);
        }
        if (Request()->has('driver_id') && Request()->get('driver_id') != '') {
            $driver_id = Request()->get('driver_id');
            $search['driver_id'] = $driver_id;
            $orders = $orders->where('driver_id'  ,$driver_id);
            $driver = Driver::find($driver_id);
        }
        if ($request->has('date_from') && $request->get('date_from') != '') {
            $date_from = Carbon::parse($request->get('date_from') );
            $search['date_from'] = $request->get('date_from');
            $orders = $orders->whereDate('day_date', '>=', $date_from);
            if (!$request->has('date_to') || $request->get('date_to') == '') {
                $orders = $orders->whereDate('day_date', '=', $date_from);
            }
        }
        if ($request->has('date_to') && $request->get('date_to') != '') {
            $date_to = Carbon::parse($request->get('date_to') );
            $search['date_to'] = $request->get('date_to');
            $orders = $orders->whereDate('day_date', '<=', $date_to);
        }
        if (Request()->has('id') && Request()->get('id') != '') {
            $id = Request()->get('id');
            $search['id'] = $id;
            $orders = $orders->where('id'     ,$id);
        }

        if (Request()->has('driver') && Request()->get('driver') != '') {
            $driver = Request()->get('driver');
            $search['driver'] = $driver;
            $orders = $orders->wherehas('Driver', function($q) use ($driver){
                $q->where('name'     , 'LIKE', '%'.$driver.'%')
                ->Orwhere('phone'     , 'LIKE', '%'.$driver.'%');
            });
        }
        if (Request()->has('size') && Request()->get('size') != '') {
            $size = Request()->get('size');
            $search['size'] = $size;
            $orders = $orders->wherehas('Car', function($q) use ($size){
                $q->where('size'     , 'LIKE', '%'.$size.'%');
            });
        }
        if (Request()->has('status') && Request()->get('status') != '') {
            $status = Request()->get('status');
            $search['status'] = $status;
            $orders = $orders->where('status'     ,$status);
        }
        if (Request()->has('payment_type') && Request()->get('payment_type') != '') {
            $payment_type = Request()->get('payment_type');
            $search['payment_type'] = $payment_type;
            $orders = $orders->where('payment_type'     ,$payment_type);
        }
        $items['driver'] = $driver;
        $items['data'] = $orders->get()->groupBy('day_date');
        // return view('admin.reports.orders-by-day-excel', ['items' => $orders->get()->groupBy('day_date') ]);
        return Excel::download(new GeneralExport($items, 'admin.reports.orders-by-day-excel'), 'orders-'.Carbon::now()->toDateString().'.xlsx');
    }
    public function CitiesOrderView(Request $request)
    {
        $search = array();
        $title = "تقرير الزونات";
        return view('admin.reports.cities', compact('search', 'title'));
    }
    public function CitiesOrder(Request $request)
    {
        // return $request->all();
        $orders = Order::where('status', '<>', 'canceled')->latest();
        $driver = null;
        $search = array();
        if (Request()->has('user_id') && Request()->get('user_id') != '') {
            $user_id = Request()->get('user_id');
            $search['user_id'] = $user_id;
            $orders = $orders->where('user_id'  ,$user_id);
        }
        if (Request()->has('city_id') && Request()->get('city_id') != '') {
            $city_id = Request()->get('city_id');
            $search['city_id'] = $city_id;
            $orders = $orders->where('city_id'  ,$city_id);
        }
        if (Request()->has('driver_id') && Request()->get('driver_id') != '') {
            $driver_id = Request()->get('driver_id');
            $search['driver_id'] = $driver_id;
            $orders = $orders->where('driver_id'  ,$driver_id);
            $driver = Driver::find($driver_id);
        }
        if ($request->has('date_from') && $request->get('date_from') != '') {
            $date_from = Carbon::parse($request->get('date_from') );
            $search['date_from'] = $request->get('date_from');
            $orders = $orders->whereDate('day_date', '>=', $date_from);
            if (!$request->has('date_to') || $request->get('date_to') == '') {
                $orders = $orders->whereDate('day_date', '=', $date_from);
            }
        }
        if ($request->has('date_to') && $request->get('date_to') != '') {
            $date_to = Carbon::parse($request->get('date_to') );
            $search['date_to'] = $request->get('date_to');
            $orders = $orders->whereDate('day_date', '<=', $date_to);
        }
        if (Request()->has('id') && Request()->get('id') != '') {
            $id = Request()->get('id');
            $search['id'] = $id;
            $orders = $orders->where('id'     ,$id);
        }

        if (Request()->has('driver') && Request()->get('driver') != '') {
            $driver = Request()->get('driver');
            $search['driver'] = $driver;
            $orders = $orders->wherehas('Driver', function($q) use ($driver){
                $q->where('name'     , 'LIKE', '%'.$driver.'%')
                ->Orwhere('phone'     , 'LIKE', '%'.$driver.'%');
            });
        }
        if (Request()->has('size') && Request()->get('size') != '') {
            $size = Request()->get('size');
            $search['size'] = $size;
            $orders = $orders->wherehas('Car', function($q) use ($size){
                $q->where('size'     , 'LIKE', '%'.$size.'%');
            });
        }
        if (Request()->has('status') && Request()->get('status') != '') {
            $status = Request()->get('status');
            $search['status'] = $status;
            $orders = $orders->where('status'     ,$status);
        }
        if (Request()->has('payment_type') && Request()->get('payment_type') != '') {
            $payment_type = Request()->get('payment_type');
            $search['payment_type'] = $payment_type;
            $orders = $orders->where('payment_type'     ,$payment_type);
        }
        // return $orders->get()->groupBy(['city_id','driver_id', 'day_date']);
        // $items['driver'] = $driver;
        // $items['data'] = $orders->get()->groupBy(['city_id','driver_id', 'day_date']);
        // return view('admin.reports.orders-by-day-excel', ['items' => $orders->get()->groupBy('day_date') ]);
        return Excel::download(new GeneralExport($orders->get()->groupBy(['city_id','driver_id', 'day_date']), 'admin.reports.cities-by-day-excel'), 'orders-'.Carbon::now()->toDateString().'.xlsx');
    }
}
