<?php

namespace App\Mail;

use App\Models\Order;
use App\Models\Subscribe;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class SBillEmail extends Mailable
{
    use Queueable, SerializesModels;
    protected $subscribe;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($subscribe)
    {
        $this->subscribe = $subscribe;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $subscribe = Subscribe::find($this->subscribe);
        return $this->view('admin.subscribes.bill', compact('subscribe'));
    }
}
