<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Tymon\JWTAuth\Contracts\JWTSubject;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Carbon\CarbonPeriod;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\SoftDeletes;


class Driver extends Authenticatable implements JWTSubject
{
    use Notifiable, SoftDeletes;

    protected $table='drivers';
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $appends = ['zones', 'shifts'];
    protected $fillable = [
        'first_name', 'last_name', 'password', 'email' , 'phone' ,'city_id' , 'verify_code', 'lang', 'image', 'active', 'license_number', 'license_date',
        'identity_number', 'identity_date', 'chasis', 'start_job', 'recieve_equib_date', 'latitude', 'longitude', 'name', 'zone_id', 'service_id',
        'target', 'shift_id',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];
    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
// Rest omitted for brevity

    /**
     * Get the identifier that will be stored in the subject claim of the JWT.
     *
     * @return mixed
     */
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [];
    }
    /**
     * Get all of the post's Files.
     */
    public function PlayerId()
    {
        return $this->morphMany(PlayerId::class, 'taggable');
    }
    public function City()
    {
        return $this->belongsTo(City::class, 'city_id');
    }
    public function Zone()
    {
        return $this->belongsTo(City::class, 'zone_id');
    }
    public function Service()
    {
        return $this->belongsTo(Service::class, 'service_id');
    }

    public function Order()
    {
        return $this->Hasmany(Order::class, 'driver_id');
    }

    public function Vacation()
    {
        return $this->Hasmany(Vacation::class, 'driver_id');
    }

    public function DriverZone()
    {
        return $this->Hasmany(DriverZone::class, 'driver_id');
    }
    public function DriverShift()
    {
        return $this->Hasmany(DriverShift::class, 'driver_id');
    }
    public function Finance()
    {
        return $this->Hasmany(OrderFinance::class, 'driver_id');
    }

    public function OrderFinance()
    {
        return $this->hasManyThrough(OrderFinance::class, Order::class, 'driver_id', 'order_id');
    }


    public function getImageAttribute($img)
    {
        if($img)
        {
            return url('/').'/cdn/'.$img;
        }
        return $img;

    }
    public function getZonesAttribute()
    {
        return $this->DriverZone()->pluck('zone_id')->toArray();

    }
    public function getShiftsAttribute()
    {
        return $this->DriverShift()->pluck('shift_id')->toArray();

    }
    // public function getCreatedAtAttribute($date)
    // {
    //     if(Auth::check())
    //         return Carbon\Carbon::createFromFormat('Y-m-d H:i:s', $date)->copy()->tz(Auth::user()->timezone)->format('F j, Y @ g:i A');
    //     else
    //         return Carbon\Carbon::createFromFormat('Y-m-d H:i:s', $date)->copy()->tz('America/Toronto')->format('F j, Y @ g:i A');
    // }

    // public function getUpdatedAtAttribute($date)
    // {
    //     return Carbon\Carbon::createFromFormat('Y-m-d H:i:s', $date)->format('F j, Y @ g:i A');
    // }
    public function getOwedDriver()
    {

        $rows = $this->OrderFinance()->whereNotNull('order_id')->whereHas('Order', function($q){$q->where('status', 'completed');})->get();
        // $days = Order::whereIn('id',$rows->pluck('order_id')->toArray())->groupBy('day_date')->count();
        $days = $rows->groupBy(\DB::raw('Date(created_at)'))->count();
        // days new
        $last_collected = $this->finance()->latest()->first();
        if ($last_collected) {
            $start_date = Carbon::parse($last_collected->created_at->todatestring());
            $end_date = Carbon::now()->todatestring();
            $days =  sizeof($this->arr_of_days($start_date, $end_date, $this->Vacation()->pluck('day_date')->toArray() ));
            // $days = $start_date->diffInDays($end_date);
        }
        // days new
        $p = $rows->sum('services_amount') - ($days * $this->target) - $this->getTotalAmountCollectedByDriver();
        return round($p, 2);
    }
    public function getOwedCompany()
    {

        $rows = $this->OrderFinance()->whereNotNull('order_id')->whereHas('Order', function($q){$q->where('status', 'completed');})->get();
        // $days = Order::whereIn('id',$rows->pluck('order_id')->toArray())->groupBy('day_date')->count();
        $days = $rows->groupBy(\DB::raw('Date(created_at)'))->count();
        // days new
        $last_collected = $this->finance()->latest()->first();
        if ($last_collected) {
            $start_date = Carbon::parse($last_collected->created_at->todatestring());
            $end_date = Carbon::now()->todatestring();
            $days =  sizeof($this->arr_of_days($start_date, $end_date, $this->Vacation()->pluck('day_date')->toArray() ));
            // $days = $start_date->diffInDays($end_date);
        }
        // days new
        $p = round($rows->sum('total_amount') - ($rows->sum('services_amount') - ($days * $this->target)), 2) - $this->getTotalAmountCollectedByCompany();
        return round($p, 2);
    }
    public function arr_of_days($start_date, $end_date, $vac = [])
    {
        $period = CarbonPeriod::create($start_date, $end_date);
        $arr = [];
        foreach ($period as $date) {
            if (in_array($date->format('Y-m-d'), $vac)) {
                continue;
            }
            $arr[] = $date->format('Y-m-d');
        }
        return $arr;
        // Convert the period to an array of dates
        return $dates = $period->toArray();
    }
    public function getServiceTotal()
    {

        $rows = $this->OrderFinance()->whereNotNull('order_id')->whereHas('Order', function($q){$q->where('status', 'completed');})->get();
        // $days = Order::whereIn('id',$rows->pluck('order_id')->toArray())->groupBy('day_date')->count();
        $days = $rows->groupBy(\DB::raw('Date(created_at)'))->count();
        return $rows->sum('services_amount');
    }
    public function getTotalAmountCollectedByDriver()
    {

        $rows = $this->Finance()->where('type', 'creditor')->get();
        // $days = Order::whereIn('id',$rows->pluck('order_id')->toArray())->groupBy('day_date')->count();
        $days = $rows->groupBy(\DB::raw('Date(created_at)'))->count();
        return $rows->sum('driver_amount');
    }
    public function getTotalAmountCollectedByCompany()
    {

        $rows = $this->Finance()->where('type', 'creditor')->get();
        // $days = Order::whereIn('id',$rows->pluck('order_id')->toArray())->groupBy('day_date')->count();
        $days = $rows->groupBy(\DB::raw('Date(created_at)'))->count();
        return $rows->sum('company_amount');
    }
}
