<?php
namespace App\Traits\Admin;

use App\Mail\SBillEmail;
use App\Models\PriceList;
use Illuminate\Http\Request;
use App\Models\Subscribe;
use DB;
use Mail;
use Carbon\Carbon;

trait SubscribeOperations
{


    /**
     * Register a New .
     *
     * @param $request
     * @return \App\
     */
    public function register ($request)
    {
        $data = $request->all();
        // dd($data);

        if ($request->hasFile('image')) {
            $data['image'] = uploadImage($request->file('image'));
        }
        DB::beginTransaction();
        $Subscribe = Subscribe::create($data);
        if ($request->has('features') ) {
            foreach ($request->get('features') as $it) {
                // dd($it);
                if (isset($it['qty']) && !in_array($it['qty'], [null, ''])) {
                    $it['service_id'] = $data['service_id'];
                    $pricelist = PriceList::where('service_id', $data['service_id'])->where('size', $it['size'])->first();
                    if ($pricelist) {
                        $it['price'] = $pricelist->price;

                    }
                    $Subscribe->SubscribeItem()->create($it);

                }
            }
        }
        DB::commit();
        return $Subscribe;
    }


    /**
     * Update Record
     * @param $truck
     * @param $request
     */
    public function UpdateRecords(Subscribe $Subscribe,$request)
    {
        $data = $request->all();
        if ($request->hasFile('image')) {
            @unlink(public_path('/cdn/'.$Subscribe->image));
            //
            $data['image'] = uploadImage($request->file('image'));
        }
        $Subscribe->update($data);
        $Subscribe->SubscribeItem()->whereNotNull('size')->delete();
        if ($request->has('features') ) {
            foreach ($request->get('features') as $it) {
                // dd($it);
                if (isset($it['qty']) && !in_array($it['qty'], [null, ''])) {
                    $it['service_id'] = $data['service_id'];

                    $pricelist = PriceList::where('service_id', $data['service_id'])->where('size', $it['size'])->first();
                    if ($pricelist) {
                        $it['price'] = $pricelist->price;

                    }
                    $Subscribe->SubscribeItem()->create($it);

                }
            }
        }
        try {
            Mail::to($Subscribe->User()->first())->send(new SBillEmail($Subscribe->id));
        } catch (\Throwable $th) {
            //throw $th;
        }
        return $Subscribe;
    }
    /**
     * delete Record
     * @param $truck
     * @param $request
     */
    public function DeleteRecord($id)
    {
        //
    }
}
