<?php
namespace App\Traits\Api;

use App\Mail\Api\DriverVerify as DriverVerifyMail;
use Illuminate\Http\Request;
use App\Models\DeliveryDriver;
use App\Models\Driver;
use Mail;
use DB;

trait DriverOperations
{
  

    /**
     * Register a New .
     *
     * @param $request
     * @return \App\
     */
    public function register ($request)
    {
        $data = (array)$request->except('player_id');
        $api_token      = str_random(60);
        // while ( Driver::where('api_token',$api_token)->count() > 0 ) {                    
        //     $$api_token = str_random(60);
        // }
        $code = mt_rand(1000,9999);
        // while ( Driver::where('code',$code)->count() > 0 ) {                    
        //     $code = mt_rand(1000,9999);
        // }
        // $data['api_token'] = $api_token;
        $data['password'] = bcrypt($request->get('password'));
        if ($request->hasFile('image')) {
            $data['image'] = uploadFile($request);
        }
        // base64
        if ($request->has('os') && $request->get('os') == 'android' && $request->has('image')) {
            $data['image'] = uploadImageBase64($request->get('image'));
            // 
        }
        // base64
        DB::beginTransaction();
            $Driver = Driver::create($data);
            if ($request->has('player_id') && $request->get('player_id') != '') {
                $Driver->PlayerId()->create(['player_id' => $request->player_id]);
            }
        DB::commit();
        return $Driver;
    }


    /**
     * Update Record
     * @param $truck
     * @param $request
     */
    public function UpdateRecords(Driver $Driver,$request)
    {
        $data = $request->all();
        if ($request->hasFile('image')) {
            @unlink(public_path('/cdn/'.$Driver->image));
            // 
            $data['image'] = uploadFile($request);
        }
        // base64
        if ($request->has('os') && $request->get('os') == 'android' && $request->has('image')) {
            $data['image'] = uploadImageBase64($request->get('image'));
        }
        // base64
        if ($request->has('password') && $data['password'] != '') {
            $data['password'] = bcrypt($data['password']);
        }else{
            unset($data['password']);
        }
        if ($request->has('phone') && $data['phone'] != '' ) {
            // 
            $data['verify_code'] = null;
        }else{
            unset($data['phone']);
        }
        $Driver->update($data);
        return $Driver;
    }
}