@extends('admin.layout.app')
@section('style')
@endsection
@section('header')
<!-- Page title -->


<li>
    <div class="add-btn {!! (CheckPermission('drivers_add'))? '' : 'hidden'  !!}">
        <a href="{{ url('/dashboard/drivers/create') }}" type="button"
            class="btn btn-custom btn-rounded waves-effect waves-light w-md m-b-5"> <i class="fa fa-check"></i> اضافة
        </a>
    </div>
</li>

@endsection
@section('content')


<div class="row">

    <div class="col-sm-12">
        <div class="card-box">
            <form action="" method="get">
                <div class="row">
                    <div class="col-md-12 part-top">
                        <div class="row">

                        </div>
                    </div>

                    <div class="col-md-12">
                        <div class="row">


                            <div class="col-lg-2">
                                <div class="form-horizontal">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <input type="text" name="name"
                                                value="{{(array_key_exists('name', $search))? $search['name'] : ''}}"
                                                class="form-control" placeholder=" اسم السائق">
                                        </div>
                                    </div>

                                </div>
                            </div>

                            <div class="col-lg-2">
                                <div class="form-horizontal">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <input type="text" name="phone"
                                                value="{{(array_key_exists('phone', $search))? $search['phone'] : ''}}"
                                                class="form-control" placeholder=" رقم جوال السائق">
                                        </div>
                                    </div>

                                </div>
                            </div>

                            <div class="col-lg-2">
                                    <button type="button"
                                        onclick="$(this).closest('form').find('#excel').remove(); $(this).closest('form').submit();"
                                        class="btn btn-block btn-sm btn-success waves-effect waves-light b-t-10 b-b-10"><i
                                            class="fa fa-search"></i> بحث</button>
                            </div>

                            <div class="col-lg-2">
                                <div class="form-horizontal">
                                    <a href="{{url('/dashboard/drivers')}}"
                                        class="btn btn-block btn-sm btn-success waves-effect waves-light b-t-10 b-b-10"><i
                                            class="fa fa-trash"></i> مسح خيارات البحث</a>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Page-Title -->
<div class="row">

    <div class="col-sm-12">
        <div class="card-box text-left">
            <div class="row">
                {{--  'first_name', 'last_name', 'password', 'email' , 'phone' ,'city_id' , 'verify_code', 'lang', 'image',  --}}
                <div class="col-lg-12">
                    <div class="box-tebal">

                        <div role="tabpanel" class="tab-pane " style="overflow: hidden;">
                            <table id="datatable-buttons" class="table table-striped table-bordered">
                                <thead>
                                    <tr>

                                        <th>#</th>
                                        <th> الصوره </th>
                                        <th> الاسم  </th>
                                        {{-- <th> الاسم الاول </th>
                                        <th> الاسم الاخير </th> --}}
                                        <th> البريد الالكترونى </th>
                                        <th>رقم الجوال </th>
                                        <th> الزون </th>
                                        <th> الخدمة </th>
                                        <th> مبالغ مستحقه للشركة </th>
                                        <th> مبالغ مستحقه للسائق </th>
                                        <th> العمليات</th>



                                    </tr>
                                </thead>

                                <tbody>
                                    @foreach($drivers as $item)
                                    <tr>
                                        <td> {{$item->id}}</td>
                                        <td> <img src="{{getImage($item->image)}}" height="100" width="100"> </td>
                                        <td> {{$item->name}}</td>
                                        {{-- <td> {{$item->first_name}}</td> --}}
                                        {{-- <td> {{$item->last_name}}</td> --}}
                                        <td>{{$item->email}}</td>
                                        <td> {{$item->phone}}</td>
                                        <td>{{$item->Zone->name_ar ?? ''}}</td>
                                        <td>{{$item->Service->name_ar ?? ''}}</td>
                                        <td>{{$item->getOwedCompany()}} ريال</td>
                                        <td>{{$item->getOwedDriver()}} ريال</td>

                                        <td class="btns">
                                            <a href="/dashboard/drivers/{{$item->id}}/edit" type="button"
                                                class="btn btn-info   waves-effect waves-light m-b-5 btn-xs {!! (CheckPermission('drivers_edit'))? '' : 'hidden'  !!}"> <i
                                                    class="fa fa-pencil"></i> تعديل </a>
                                            <a href="{{route('drivers.destroy',$item)}}" id="delete-btn" type="button"
                                                class="btn btn-danger   waves-effect waves-light m-b-5 btn-xs {!! (CheckPermission('drivers_delete'))? '' : 'hidden'  !!}"> <i
                                                    class="fa fa-times"></i> حذف </a>
                                            <a href="/dashboard/drivers/{{$item->id}}" type="button" title="عرض"
                                                class="btn btn-info   waves-effect waves-light m-b-5 btn-xs {!! (CheckPermission('drivers_show'))? '' : 'hidden'  !!}"> <i
                                                    class="fa fa-eye"></i> عرض </a>

                                        </td>
                                    </tr>
                                    @endforeach



                                </tbody>
                            </table>
                            {!! $drivers->appends($search)->links() !!}
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div><!-- end col -->
</div>
<!-- end row -->
@endsection
@section('script')
@endsection
