@extends('admin.layout.app')
@section('style')
@endsection
@section('content')
<!-- Page-Title -->
<div class="row">
    <div class="col-sm-12">
        <div class="btn-group pull-right m-t-15">
            <a href="{{url('/dashboard/times/create')}}" class="btn btn-info waves-effect w-md waves-light m-b-5">
                <i class="fa fa-pencil m-r-5"></i>
                <span>إضافة  </span>
            </a>
        </div>
    </div>
</div>


<div class="row">
    
    <div class="col-sm-12">
        <div class="card-box table-responsive">
            <div class="row">

                <div class="col-md-12">
                    <div class="tab-content">

                        
                        <div role="tabpanel" class="tab-pane active" id="customers">
                            <table id="datatable-0" class="table table-striped table-bordered">
                                <thead>
                                    <tr>
                                        <th> اليوم</th>
                                        <th> الاوقات </th>
                                        <th>تعديل</th>
                                        <th>حذف</th>
                                    </tr>
                                </thead>

                                <tbody>
                                    @foreach($times as $item)
                                    <tr>
                                        <td> {{$item->day ?? ''}} </td>
                                        <td> {{$item->times}} </td>
                                        
                                        <td><a href="/dashboard/times/{{$item->id}}/edit"><i class="fa fa-pencil  m-r-10" style="color: #188ae2;"></i> تعديل</a></td>
                                        <td> <a href="{{route('times.destroy',$item)}}" id="delete-btn" ><i class="fa fa-trash-o m-r-10" style="color: #5b69bc;"></i> حذف</a></td>
                                    </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>

                    </div>
                    
                </div>
            </div>
            
        </div>
    </div><!-- end col -->
</div>
<!-- end row -->
@endsection
@section('script')
@endsection