<?php

namespace App\Exceptions;

use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Throwable;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Symfony\Component\HttpKernel\Exception\AccessDeniedHttpException;
use Symfony\Component\HttpKernel\Exception\HttpException;
use Symfony\Component\HttpKernel\Exception\MethodNotAllowedHttpException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\Routing\Exception\MethodNotAllowedException;
use Illuminate\Auth\AuthenticationException;
use InfyOm\Generator\Utils\ResponseUtil;
use Response;

class Handler extends ExceptionHandler
{
    /**
     * A list of the exception types that are not reported.
     *
     * @var array
     */
    protected $dontReport = [
        //
    ];

    /**
     * A list of the inputs that are never flashed for validation exceptions.
     *
     * @var array
     */
    protected $dontFlash = [
        'password',
        'password_confirmation',
    ];

    /**
     * Report or log an exception.
     *
     * @param  \Throwable  $exception
     * @return void
     *
     * @throws \Throwable
     */
    public function report(Throwable $exception)
    {
        parent::report($exception);
    }

    /**
     * Render an exception into an HTTP response.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Throwable  $exception
     * @return \Symfony\Component\HttpFoundation\Response
     *
     * @throws \Throwable
     */
    public function render($request, Throwable $exception)
    {
        if ($exception instanceof \Tymon\JWTAuth\Exceptions\TokenInvalidException) {
            return Response::json(ResponseUtil::makeError('Token is invalid'), 200);
        }
        if ($exception instanceof \Tymon\JWTAuth\Exceptions\TokenExpiredException) {
            return Response::json(ResponseUtil::makeError('Token has expired'), 200);
        }

        // NotFoundHttpException
        if ($request->is('api/*')) {
            if ($exception instanceof \Illuminate\Database\Eloquent\ModelNotFoundException || (method_exists($exception, 'getStatusCode') && $exception->getStatusCode() == 404)) {
                
                    return Response()->json([
                        'data' => new \stdClass,
                        'message' => 'notFound',
                        'code' => getMsgCode('notFound')
                ]);
            }
        }
        return parent::render($request, $exception);
    }

    protected function unauthenticated($request, AuthenticationException $exception)
    {
        if ($request->expectsJson() || $request->ajax() || $request->wantsJson() || $request->segment(1) == 'api') {
            return Response()->json([
                    'data' => new \stdClass,
                    'message' => 'authFailed',
                    'code' => getMsgCode('authFailed')
            ]);
        }

        return redirect()->guest(route('login'));
    }
}
