<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Traits\Admin\BrandOperations;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\Brand;
use Auth;
use Excel;
use App\Exports\GeneralExport;
use Carbon\Carbon;

class BrandController extends Controller
{
    use BrandOperations;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    // public function __construct()
    // {
    //     $this->middleware('Permission:Brand_show'    , ['only' => 'index', 'show']);
    //     $this->middleware('Permission:Brand_add'     , ['only' => 'create', 'store']);
    //     $this->middleware('Permission:Brand_edit'    , ['only' => 'edit', 'update']);
    //     $this->middleware('Permission:Brand_delete'  , ['only' => 'destroy']);
    // }
    public function index()
    {
        $title = 'الماركات';
        $brands = Brand::latest();
            $search = array();
            if (Request()->has('id') && Request()->get('id') != '') {
                $id = Request()->get('id');
                $search['id'] = $id;
                $brands = $brands->where('id',$id);
            }
            if (Request()->has('name') && Request()->get('name') != '') {
                $name = Request()->get('name');
                $search['name'] = $name;
                $brands = $brands->where('structure_no'     , 'LIKE', '%'.$name.'%')->orWhere('name'     , 'LIKE', '%'.$name.'%');
            }
            if (Request()->has('excel') && Request()->get('excel') != '') {
                $brands = $brands->get();
                return Excel::download(new GeneralExport('admin.reports.brands-excel', $brands), 'brands-'.Brandbon::now()->toDateString().'.xlsx');
            }
            $brands = $brands->paginate(40);
        return view('admin.brands.index', compact('brands', 'title' , 'search'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة ';
        return view('admin.brands.add', compact('title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->register($request);
        return redirect('/dashboard/brands')->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Brand $brand)
    {
        $title = 'عرض ';
        return view('admin.brands.show', compact('brand', 'title'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $brand = Brand::find($id);
        $title = 'تعديل ';
        return view('admin.brands.edit', compact('brand', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
      
        $brand = Brand::find($id);
        $this->UpdateRecords($brand, $request);
      
        return redirect('dashboard/brands');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Brand $brand)
    {
        if ($brand->form_image) {
            @unlink(public_path('/cdn/'.$brand->form_image));
        }
        $brand->delete();
        return 'success';
    }
}
