<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Traits\Admin\VacationOperations;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\Vacation;
use Auth;
use Carbon\Carbon;

class VacationController extends Controller
{
    // use VacationOperations;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    
    public function __construct()
    {
        $this->middleware('Permission:vacations_show'    , ['only' => 'index', 'show']);
        $this->middleware('Permission:vacations_add'     , ['only' => 'create', 'store']);
        $this->middleware('Permission:vacations_edit'    , ['only' => 'edit', 'update']);
        $this->middleware('Permission:vacations_delete'  , ['only' => 'destroy']);
    }
    public function index()
    {
        // 
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة ';
        $driver_id = Request()->get('id');
        return view('admin.vacations.add', compact('title', 'driver_id'))->render();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        Vacation::create($request->all());
        return back()->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Vacation $vacation)
    {
        $title = 'عرض ';
        return view('admin.vacations.show', compact('vacation', 'title'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $vacation = Vacation::find($id);
        $title = 'تعديل ';
        return view('admin.vacations.edit', compact('vacation', 'title'))->render();
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
      
        $vacation = Vacation::find($id);
        $vacation->update($request->all());
      
        return back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Vacation::where('id', $id)->delete();
       
        return back();
    }
}
