<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\UpdateCouponRequest;
use App\Http\Requests\Admin\StoreCouponRequest;
use App\Http\Controllers\Controller;
use App\Traits\Admin\CouponOperations;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\Coupon;
use Auth;

class CouponController extends Controller
{
    use CouponOperations;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    
    public function __construct()
    {
        $this->middleware('Permission:coupons_show'    , ['only' => 'index', 'show']);
        $this->middleware('Permission:coupons_add'     , ['only' => 'create', 'store']);
        $this->middleware('Permission:coupons_edit'    , ['only' => 'edit', 'update']);
        $this->middleware('Permission:coupons_delete'  , ['only' => 'destroy']);
    }
    public function index()
    {
        $coupons = Coupon::latest()->get();
        $title = 'كوبونات الخصم';
        return view('admin.coupons.index', compact('coupons', 'title'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة كوبون';
        $code = \Str::random(6);
        return view('admin.coupons.add', compact('title', 'code'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreCouponRequest $request)
    {
        $this->register($request);
        return redirect('/dashboard/coupons')->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Coupon $coupon)
    {
        $title = 'عرض كوبون';
        return view('admin.coupons.show', compact('coupon', 'title'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $coupon = Coupon::find($id);
        $title = 'تعديل كوبون';
        return view('admin.coupons.edit', compact('coupon', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Coupon $coupon)
    {
        $request->validate([
            'coupon' => 'required|unique:coupons,coupon,'.$coupon->id
        ]);
        // $coupon = Coupon::find($id);
        $this->UpdateRecords($coupon, $request);
        return redirect('/dashboard/coupons')->with('success', 'data added successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Coupon $coupon)
    {
        if ($coupon->image) {
            @unlink(public_path('/cdn/'.$coupon->image));
        }
        $coupon->delete();
        return 'success';
    }
}
