<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\UpdateOrderRequest;
use App\Http\Requests\Admin\StoreOrderRequest;
use App\Http\Controllers\Controller;
use App\Traits\Admin\OrderOperations;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\Order;
use Auth;
use Excel;
use App\Exports\GeneralExport;
use Carbon\Carbon;

class OrderController extends Controller
{
    use OrderOperations;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
        $this->middleware('Permission:orders_show'    , ['only' => 'index', 'show']);
        $this->middleware('Permission:orders_add'     , ['only' => 'create', 'store']);
        $this->middleware('Permission:orders_edit'    , ['only' => 'edit', 'update']);
        $this->middleware('Permission:orders_delete'  , ['only' => 'destroy']);
    }
    public function index(Request $request)
    {
        // $orders = Order::latest();
      //////////////////// branch or admin
      if (in_array( auth('admin')->user()->role, ['branch', 'employee']) || (auth('admin')->user()->role == 'employee' && auth()->user()->parent_id != '0' )) {
        // 
        if (auth('admin')->user()->role == 'branch') {
            $branch_id = auth('admin')->id();
        } else {
            $branch_id = auth('admin')->user()->parent_id;
        }
        $orders = Order::whereHas('BranchData', function($q)use($branch_id){
            $q->where('admin_id', $branch_id);
        })->latest();
    } else {
        $orders = Order::latest();
        
    }
    ///////////////////////////
// $search=[];


        $search = array();
        if (Request()->has('serial') && Request()->get('serial') != '') {
            $serial = Request()->get('serial');
            $search['serial'] = $serial;
            $orders = $orders->where('serial'  ,$serial);
        }
        if (Request()->has('user_id') && Request()->get('user_id') != '') {
            $user_id = Request()->get('user_id');
            $search['user_id'] = $user_id;
            $orders = $orders->where('user_id'  ,$user_id);
        }
        if (Request()->has('driver_id') && Request()->get('driver_id') != '') {
            $driver_id = Request()->get('driver_id');
            $search['driver_id'] = $driver_id;
            $orders = $orders->where('driver_id'  ,$driver_id);
        }
        if ($request->has('date_from') && $request->get('date_from') != '') {
            $date_from = Carbon::parse($request->get('date_from') );
            $search['date_from'] = $request->get('date_from');
            $orders = $orders->whereDate('day_date', '>=', $date_from);
            if (!$request->has('date_to') || $request->get('date_to') == '') {
                $orders = $orders->whereDate('day_date', '=', $date_from);
            }
        }
        if ($request->has('date_to') && $request->get('date_to') != '') {
            $date_to = Carbon::parse($request->get('date_to') );
            $search['date_to'] = $request->get('date_to');
            $orders = $orders->whereDate('day_date', '<=', $date_to);
        }
        if (Request()->has('id') && Request()->get('id') != '') {
            $id = Request()->get('id');
            $search['id'] = $id;
            $orders = $orders->where('id'     ,$id);
        }
        
        if (Request()->has('user') && Request()->get('user') != '') {
            $user = Request()->get('user');
            $search['user'] = $user;
            $orders = $orders->wherehas('User', function($q) use ($user){
                $q->where('name'     , 'LIKE', '%'.$user.'%')
                ->Orwhere('phone'     , 'LIKE', '%'.$user.'%');
            });
        }
        if (Request()->has('service') && Request()->get('service') != '') {
            $service = Request()->get('service');
            $search['service'] = $service;
            $orders = $orders->where('service_id'     ,$service);
        }
        if (Request()->has('driver') && Request()->get('driver') != '') {
            $driver = Request()->get('driver');
            $search['driver'] = $driver;
            $orders = $orders->where('driver_id'     ,$driver);
        }
        if (Request()->has('status') && Request()->get('status') != '') {
            $status = Request()->get('status');
            $search['status'] = $status;
            $orders = $orders->where('status'     ,$status);
        }
        if (Request()->has('excel') && Request()->get('excel') != '') {
            $orders = $orders->get();
            return Excel::download(new GeneralExport('admin.reports.orders-excel', $orders), 'orders-'.Carbon::now()->toDateString().'.xlsx');
        }
        $orders = $orders->paginate(40);
        $title = 'الحجزات';
              
        return view('admin.orders.index', compact('orders', 'title' ,'search'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $title = 'اضافة حجز';
        return view('admin.orders.add', compact('title'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreOrderRequest $request)
    {
        $this->register($request);
        // return view('admin.orders.add');
        return redirect()->back()->with('success', 'data added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Order $order)
    {
        $title = 'عرض حجز';
        return view('admin.orders.show', compact('order', 'title'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $order = Order::find($id);
        $title = 'تعديل حجز';
        return view('admin.orders.edit', compact('order', 'title'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateOrderRequest $request, $id)
    {
      
        $order = Order::find($id);
        $this->UpdateRecords($order, $request);
        return redirect()->back()->with('success', 'data updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Order $order)
    {
        $order->delete();
        return 'success';
    }
}
