<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\City;
use App\Http\Resources\Api\CityResource;
use App\Models\Brand;
use App\Http\Resources\Api\BrandResource;
use App\Http\Resources\Api\BrandModelResource;
use App\Models\Color;
use App\Http\Resources\Api\ColorResource;
use App\Http\Controllers\Admin\CityController;
use App\Models\Order;
use App\Models\Service;
use App\Models\Setting;
use App\Models\Driver;
use Carbon\Carbon;
use Carbon\CarbonInterval;

class AppInfoController extends Controller
{
    public function index($type = 'home')
    {

        $info = Setting::pluck('value', 'key')->toArray();
        $info['tax'] = round((float)$info['tax'], 2);
        
        return Response()->json([
                'data' => [
                    'info' => $info,
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }
    public function cities()
    {
        $cities = City::whereIn('parent', ['0', ''])->get();
        $cities = CityResource::collection($cities);
        return response()->json([
            'data'   => [
                'cities' => $cities,
            ],
            'message'   => 'success',
            'code'      => getMsgCode('success')
        ]);
    }
    public function colors()
    {
        $colors = Color::get();
        $colors = ColorResource::collection($colors);
        return response()->json([
            'data'   => [
                'colors' => $colors,
            ],
            'message'   => 'success',
            'code'      => getMsgCode('success')
        ]);
    }
    public function brands()
    {
        $brands = Brand::get();
        $brands = BrandResource::collection($brands);
        return response()->json([
            'data'   => [
                'brands' => $brands,
            ],
            'message'   => 'success',
            'code'      => getMsgCode('success')
        ]);
    }
    public function brandmodels($id)
    {
        $brand_models = Brand::find($id);
        $brand_models = $brand_models->BrandModel()->get();
        $brand_models = BrandModelResource::collection($brand_models);
        return response()->json([
            'data'   => [
                'brand_models' => $brand_models,
            ],
            'message'   => 'success',
            'code'      => getMsgCode('success')
        ]);
    }
    public function checkPoint(Request $request)
    {
        $lat = $request->get('latitude');
        $long = $request->get('longitude');
        $city_c = new CityController;
        $res = 0;
        $cities = City::get();
        $item = null;
        $city = null;
        foreach ($cities as $item) {
            $resu = $city_c->checkP($item->id, $lat , $long);
            if ($resu == true) {
                if (Driver::where('zone_id', $item->id)->count() > 0) {
                    $res = 1;
                    $city = $item;
                }
                break;
            }
        }
        if ($res) {
            $city = new CityResource($city);
        }
        return response()->json([
            'data'   => [
                'result' => $res,
                'city' => $city,
            ],
            'message'   => 'success',
            'code'      => getMsgCode('success')
        ]);
    }
    public function checkPointForZone(Request $request)
    {
        $lat = $request->get('latitude');
        $long = $request->get('longitude');
        $city_c = new CityController;
        $res = 0;
        $cities = City::whereHas('DriverZone')->get();
        $item = null;
        $city = null;
        foreach ($cities as $item) {
            $resu = $city_c->checkP($item->id, $lat , $long);
            if ($resu == true) {
                $res = 1;
                $city = $item;
                break;
            }
        }
        return $city;
    }
    public function getTimes(Request $request)
    {
        $service_id = $request->get('service_id');
        $minutes = Service::find($service_id)->take_minutes;
        $day_date = $request->get('day_date');
        $city_id = '';
        // return Carbon::now()->format('Y-m-d H:i:m');
        if ($request->has('city_id') && $request->city_id) {
            $city_id = $request->get('city_id');
        }
        $s_t=getSettingValue('start_time');
        if (!Carbon::parse($day_date)->gt(Carbon::today())) {
            $s_t_h=Carbon::parse(getSettingValue('start_time'))->format('H');
            $s_t_i_s=Carbon::parse(getSettingValue('start_time'))->format('i:s');
            $n_t = Carbon::now()->format('H:i').':00';
            $n_t_h = Carbon::now()->format('H');
            if ($n_t_h > $s_t_h) {
                $s_t = $n_t_h . ':'.$s_t_i_s;
            }
            // return $n_t_h;
            if ($n_t_h > Carbon::parse(getSettingValue('end_time'))->format('H') || Carbon::parse($day_date)->lt(Carbon::today())) {
                return response()->json([
                    'data'   => [
                        'times' => [],
                    ],
                    'message'   => 'success',
                    'code'      => getMsgCode('success')
                ]);
            }
        }
        $times = $this->checkTime($s_t, getSettingValue('end_time'), $minutes,$day_date, $city_id, $service_id, $request);
        return response()->json([
            'data'   => [
                'times' => $times,
            ],
            'message'   => 'success',
            'code'      => getMsgCode('success')
        ]);
    }

    public function checkTime($start = '09:00:00', $end = '22:00:00', $period = 60, $day_date, $city_id = '', $service_id = '', Request $request)
    {
        $day_date= Carbon::parse($day_date);
        $startTime= Carbon::parse($start);
        $stime = ($startTime->hour * 60) + $startTime->minute;
        $endTime= Carbon::parse($end);
        $etime = ($endTime->hour * 60) + $endTime->minute;
        $orders = Order::withTrashed()->whereDate('day_date', $day_date)->where('status', '<>', 'completed');
        // $drivers_count = Driver::where('active', '1')->whereDoesntHave('Vacation', function($q)use($day_date){$q->whereDate('day_date', $day_date);});
        $drivers_count = Driver::where('active', '1')
                                ->whereDoesntHave('Vacation', function($q)use($day_date){
                                    $q->whereDate('day_date', $day_date);
                                });
        $zone = $this->checkPointForZone($request);
        if ($city_id != '') {
            $orders = $orders->where('city_id', $city_id);
            // $orders = $orders->where('city_id', $city_id);
            $drivers_count = $drivers_count->where('zone_id', $city_id);
        }
        if ($zone) {
            // $orders = $orders->where('city_id', $city_id);
            // $drivers_count = $drivers_count->where('zone_id', $zone->id);
        }
        if ($service_id != '') {
            $orders = $orders->where('service_id', $service_id);
            $drivers_count = $drivers_count->where('service_id', $service_id);
        }
        $orders = $orders/*->where('city_id', $city_id)*/->whereNotNull('end_time')->get();
        $drivers_count = $drivers_count->count();
        $c = floor(($etime - $stime) / $period);
        $p = [];
        for ($i=0; $i < $c; $i++) { 
            // here if check if available peroids or not
            $p[$i][] = $i * $period + $stime;
            $p[$i][] = $i * $period + $stime + $period;
        }
        $filter = [];
        $ii = 0;
        foreach ($p as $point) {
            $flag = false;
            if ($orders->count() == 0 ) {
                $flag = true;
            }
            $c_driver_count = 0;
            foreach ($orders as $order) {
                if (($point[0] <= $order->start && $point[1] <= $order->start) || ($point[0] >= $order->end && $point[1] >= $order->end)) {
                    // $flag = true;
                }else{
                    // $flag = false;
                    // break;
                    $c_driver_count++;
                }
            }
            // return dd($drivers_count);
            if($drivers_count > $c_driver_count){
                $flag = true;
            }else{
                $flag = false;
            }
            if ($flag) {
                $time_1 = Carbon::parse(CarbonInterval::minutes($point[0])->cascade()->format('%H:%I:00') )->format('h:i a');
                $time_2 = Carbon::parse(CarbonInterval::minutes($point[1])->cascade()->format('%H:%I:00') )->format('h:i a');
                $filter[$ii++] = [$time_1 , $time_2];
            }
        }
        $res = $filter;
        return $res;
    }
    public function checkTimeT($start = '09:00:00', $end = '22:00:00', $period = 60, $day_date, $city_id = '', $service_id = '', Request $request)
    {
        $day_date= Carbon::parse($day_date);
        $startTime= Carbon::parse($start);
        $stime = ($startTime->hour * 60) + $startTime->minute;
        $endTime= Carbon::parse($end);
        $etime = ($endTime->hour * 60) + $endTime->minute;
        $orders = Order::withTrashed()->whereDate('day_date', $day_date)->where('status', '<>', 'completed');
        $drivers_count = Driver::where('active', '1');
        $zone = $this->checkPointForZone($request);
        if ($city_id != '') {
            $orders = $orders->where('city_id', $city_id);
            $drivers_count = $drivers_count->where('zone_id', $city_id);
        }
        if ($zone) {
            // $orders = $orders->where('city_id', $city_id);
            // $drivers_count = $drivers_count->where('zone_id', $zone->id);
        }
        if ($service_id != '') {
            $orders = $orders->where('service_id', $service_id);
            $drivers_count = $drivers_count->where('service_id', $service_id);
        }
        $orders = $orders/*->where('city_id', $city_id)*/->whereNotNull('end_time')->get();
        $drivers_count = $drivers_count->count();
        $c = floor(($etime - $stime) / $period);
        $p = [];
        for ($i=0; $i < $c; $i++) { 
            // here if check if available peroids or not
            $p[$i][] = $i * $period + $stime;
            $p[$i][] = $i * $period + $stime + $period;
        }
        $filter = [];
        $ii = 0;
        foreach ($p as $point) {
            $flag = false;
            if ($orders->count() == 0 ) {
                $flag = true;
            }
            $c_driver_count = 0;
            foreach ($orders as $order) {
                if (($point[0] <= $order->start && $point[1] <= $order->start) || ($point[0] >= $order->end && $point[1] >= $order->end)) {
                    // $flag = true;
                }else{
                    // $flag = false;
                    // break;
                    $c_driver_count++;
                }
            }
            // return dd($drivers_count);
            if($drivers_count > $c_driver_count){
                $flag = true;
            }else{
                $flag = false;
            }
            if ($flag) {
                $time_1 = Carbon::parse(CarbonInterval::minutes($point[0])->cascade()->format('%H:%I:00') )->format('h:i a');
                $time_2 = Carbon::parse(CarbonInterval::minutes($point[1])->cascade()->format('%H:%I:00') )->format('h:i a');
                $filter[] = $time_1;
            }
        }
        $res = $filter;
        return $res;
    }

    public function DeleteTrashedOrders()
    {
        $orders = Order::onlyTrashed()->get()->where('updated_at_stamp', '<', Carbon::now()->subMinutes(5)->timestamp);
        $orders = Order::onlyTrashed()->whereIn('id', $orders->pluck('id')->toArray() );
        $orders->forceDelete();
        return 'success';
    }
}
