<?php

namespace App\Http\Controllers\Api;

use App\Http\Requests\Api\UpdateDriverRequest;
use App\Http\Controllers\Controller;
use App\Traits\Api\DriverOperations;
use Illuminate\Http\Request;
use App\Models\Driver;
use App\Models\Order;
use Carbon\Carbon;
use Auth;
use Mail;
use Tymon\JWTAuth\Facades\JWTAuth;
use Validator;
use App\Http\Resources\Api\DriverResource;

class DriverController extends Controller
{
    use DriverOperations;

    
    public function login(Request $request)
    {
        
            // $code = $request->get('code');
            $email = $request->get('email');
            $code = $request->get('code');
            $phone = $request->get('phone');
            if ($request->has('phone')) {
                $credentials = ['phone' => $phone];
                // check user
                $driver = Driver::where('phone', $phone)->where('verify_code', $code)->first();
                // if (!$driver) {
                //     $driver = Driver::create(['phone' => $phone]);
                // }
                if($driver && $token = auth('api-driver')->login($driver))
                {
                    $driver = auth('api-driver')->user();
                    $driver->update(['verify_code' => null]);
                    if(Request()->has('player_id') && !$driver->PlayerId()->where('player_id', '=', $request->get('player_id'))->first() )
                    {
                        $driver->PlayerId()->create(['player_id' => $request->player_id]);
                    }
                    $driver->token = $token;
                    $driver = new DriverResource($driver);
                    return Response()->json([
                            'data'          => [
                                'driver'  => $driver,
                            ],
                            'message'       => 'success',
                            'code'          => getMsgCode('success'),
                        ]);
                }
            }return Response()->json([
                        'data'   => new \stdClass,
                        'errors'       => [' '],
                        'message'       => 'authFailed',
                        'code'          => getMsgCode('authFailed'),
                    ]);
    }
    
    public function SendVerifySms(Request $request)
    {
        $phone = $request->get('phone');
        $Driver = Driver::where('phone',$phone )->first();
        if (!$Driver){
            return response()->json([
                'data'   => [
                ],
                'message'   => 'notFound',
                'code'      => getMsgCode('notFound')
            ]);
        }
        
        // send sms
        $code = '2222';
        $Driver->update(['verify_code' => $code]);
            return response()->json([
                'data'   => [
                    'phone' => $Driver->phone,
                ],
                'message'   => 'success',
                'code'      => getMsgCode('success')
            ]);

    }
    public function logout()
    {
        $user = Auth::guard('api-driver')->user();
        if (Request()->has('player_id')) {
            $user->PlayerId()->where('player_id', '=', Request()->get('player_id'))->delete();
        }
        return Response()->json([
            'data'          => new \stdClass,
            'message'       => 'success',
            'code'          => getMsgCode('success'),
        ]);
    }

    public function update(Request $request)
    {
        $driver = Auth::guard('api-driver')->user();
        
        $this->UpdateRecords($driver, $request);
        $driver = Driver::find($driver->id);
        $driver->token = auth('api-driver')->tokenById($driver->id);
        $driver = new DriverResource($driver);
        return Response()->json([
                'data' => [
                    'driver' => $driver
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }
    public function profile(Request $request)
    {
        $driver = Auth::guard('api-driver')->user();
        $driver = new DriverResource($driver);
        return Response()->json([
                'data' => [
                    'driver' => $driver
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }
    public function notifications(Request $request)
    {
        $user = auth('api-driver')->user();
        $notifications  = $user->unreadnotifications;
        // return $notifications;
        return Response()->json([
                'data' => [
                    'notifications' => $notifications
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }
    
    public function notificationReaded(Request $request)
    {
        $user = auth('api-driver')->user();
        DB::table('notifications')->where('id', Request()->get('id') )->update(['read_at' => Carbon::now() ]);
        $notifications  = $user->unreadnotifications;
        return Response()->json([
                'data' => [
                    'notifications' => $notifications
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }

    public function sendSMS($destinations, $message)
    {
        $username = "Aljeri";		    // اسم المستخدم الخاص بك في الموقع 
        $password = "SmSaljeri_1330"; 		// كلمة المرور الخاصة بك 
        $destinations = $destinations; //الارقام المرسل لها  ,, يتم وضع فاصلة بين الارقام المراد الارسال لها 
        $message = $message;      // محتوى الرسالة 
        $sender = "JTC";         // اسم المرسل الخاص بك المفعل  في الموقع 
        $url = "http://www.jawalbsms.ws/api.php/sendsms?user=$username&pass=$password&to=$destinations&message=$message&sender=$sender";

        $ch = curl_init($url); // init the curl with jawalb API url
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);   
        curl_setopt($ch, CURLOPT_HEADER, 0);
        $data = curl_exec($ch);  //run curl api call, on success curl call, $data will contain the API call response
        curl_close($ch);
        // print_r($data);
    
        return $data;
    }

    public function phoneVerify()
    {
        $phone        = Request()->get('phone');
        $verifyData  = Request()->all();

        if ($user = Driver::where('verify_code',$verifyData['code'])->where('phone',$phone)->first() ){

            if( $user->update(['verify' => 1]) ){

                $user->token = auth('api-driver')->tokenById($user->id);
                return response()->json([
                        'data'      => [
                                'driver' => $user,
                        ],
                        'message'   => 'success',
                        'code'      => getMsgCode()
                ]);

            }else{
                return response()->json([
                    'data'   => new \stdClass,
                    'errors'       => [' '],
                    'message'   => 'something went wrong',
                    'code'      => getMsgCode('somethingWrong')
                ]);
            }


        }else{
             return response()->json([
                    'data'   => new \stdClass,
                    'errors'       => [' '],
                    'message'   => 'worng phone verification number',
                    'code'      => getMsgCode('wrongPhoneVerifyNum')
            ]);
        }
    }
    
    // public function SendVerifySms(Request $request)
    // {
    //     $phone = $request->get('phone');
    //     $user = Driver::where('phone',$phone )->first();
    //     if (!$user){
    //         $user = Driver::create(['phone' => $phone]);
    //     }
        
    //     // send sms
    //     $code = '2222';
    //     $user->update(['verify_code' => 2222]);
    //         return response()->json([
    //             'data'   => [
    //                 'phone' => $user->phone,
    //             ],
    //             'message'   => 'success',
    //             'code'      => getMsgCode('success')
    //         ]);

    // }
    public function statistics(Request $request)
    {
        $driver = Auth::guard('api-driver')->user();
        $balance = 50;
        $orders_count = $driver->Order()->count();
        $orders_total = $driver->Order()->sum('price');
        $commission = $driver->Order()->sum('commission');
        $driver = new DriverResource($driver);
        return Response()->json([
                'data' => [
                    'driver' => $driver,
                    'balance' => $balance,
                    'orders_count' => $orders_count,
                    'orders_total' => $orders_total,
                    'commission' => $commission,
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }
    public function AddRemittance(Request $request)
    {
        $driver = Auth::guard('api-driver')->user();
        $data = $request->all();
        $data['status'] = "pending";
        if ($request->hasFile('image')) {
            $data['image'] = uploadFile($request);
        }
        $driver->Remittance()->create($data);
        $commission = $driver->Order()->sum('commission');
        return Response()->json([
                'data' => new \stdClass,
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }
    
    public function generateOtp(Request $request)
    {
        $otp = 2222;
        \DB::table('password_resets')->insert(['email' => $request->phone, 'token' => $otp]);
        return response()->json([
            'data'   => [
                'phone' => $request->phone
            ],
            'message'   => 'success',
            'code'      => getMsgCode('success')
        ]);

    }
    public function checkOtp(Request $request)
    {
        $row = \DB::table('password_resets')->where(['email' => $request->phone, 'token' => $request->otp])->first();
        if ($row) {
            # code...
            return response()->json([
                'data'   => new \stdClass,
                'message'   => 'success',
                'code'      => getMsgCode('success')
            ]);
        }
        return response()->json([
            'data'   => new \stdClass,
            'message'   => 'notFound',
            'code'      => getMsgCode('notFound')
        ]);

    }

    public function MyWallet(Request $request)
    {
        // completed
        $driver = Auth::guard('api-driver')->user();
        $rows = $driver->OrderFinance()->where('active', '0')->whereHas('Order', function($q){$q->where('status', 'completed');})->get();
        $rows2 = $driver->Order()->where('status', '<>', 'completed')->get();
        // $days = Order::whereIn('id',$rows->pluck('order_id')->toArray())->groupBy('day_date')->count();
        $days = $rows->groupBy(\DB::raw('Date(created_at)'))->count();
        // $days;
        return Response()->json([
                // 'data' => [
                //     'money_in_wallet' => $driver->Order()->doesnthave('OrderFinance', 'or', function($q){$q->where('active', '1');})->sum('total'),
                //     'money_received' => $rows->sum('total_amount'),
                //     'orders_count' => $driver->Order()->doesnthave('OrderFinance', 'or', function($q){$q->where('active', '1');})->count(),
                // ],
                'data' => [
                    'money_in_wallet' => $rows->sum('total_amount'),
                    'services_amount' => $driver->getServiceTotal(),
                    'driver_amount' => $driver->getOwedDriver(),
                    'company_owed_amount' => $driver->getOwedCompany(),
                    'orders_count' => $rows->count(),
                    'incomplete_orders_count' => $rows2->count(),
                ],
                'message' => 'success',
                'code' => getMsgCode('success')
        ]);
    }

}
