<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class StoreDriverRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            // 'first_name'            => 'required|max:255',
            'name'             => 'required|max:255',
            'email'                 => 'nullable|email|unique:drivers|max:255',
            'phone'                 => 'required|unique:drivers|regex:/(5)[0-9]{8}/',
            // 'password'              => 'required|max:255|min:6',
            'image'                 => 'nullable|image',
        ];
    }
}
