<?php

namespace App\Http\Resources\Api;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Models\Car;
use App\Models\PriceList;

class ServiceResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $price = $this->price;
        if ($request->has('car_id')) {
            $car = Car::find($request->car_id);
            if ($car) {
                $pricel = $this->PriceList()->where('size', $car->size)->first();
                if ($pricel) {
                    $price = $pricel->price;
                }
            }
        }
        return [
            'id' => $this->id,
            'name' => $this->name,
            'description' => $this->description,
            'image' => $this->image,
            'price' => $price,
            'discount' => $this->discount,
        ];
    }
}
