<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Color extends Model
{
    protected $table='colors';
    protected $fillable = [
        'name_ar' , 'name_en' , 'color',
    ];

    protected $appends = ['name'];
    
    public function getNameAttribute()
    {
        if(Request()->header('lang') == 'ar'){ 
            return $this->name_ar;
        } else {
            return $this->name_en;
        }
    }
}
