<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Coupon extends Model
{
    protected $table = 'coupons';
    protected $fillable = [
        'coupon', 'amount', 'max', 'benefits', 'active', 'start_date', 'end_date'
    ];
	protected $guarded = ['id'];

    public function User()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    public function Order()
    {
        return $this->belongsTo(Order::class, 'coupon', 'coupon');
    }

    public function Product()
    {
        return $this->belongsTo(Product::class, 'product_id');
    }
}
