<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::group(['prefix' => '/v1', 'namespace' => 'Api'], function() {
    Route::post('contact', 'UserController@contact');
    Route::group(['prefix' => '/user'], function() {
        Route::post('/signin', 'UserController@login'); 
        Route::post('/send-verify-code', 'UserController@SendVerifySms'); 
        Route::post('/verify-phone', 'UserController@phoneVerify'); 
        Route::post('/check-user', 'UserController@CheckUser'); 
        Route::post('/forget-password', 'UserController@sendVerifyForgetPasswordNum'); 
        Route::post('/verify-forget-password', 'UserController@verifyForgetPassword'); 
        Route::group(['middleware' => 'auth:api'], function() {
            Route::post('/send-otp', 'UserController@generateOtp');
            Route::post('/check-otp', 'UserController@checkOtp');
            Route::get('/notifications', 'UserController@notifications');
            Route::post('/notification-mark-as-readed', 'UserController@notificationReaded');
            Route::post('contact', 'UserController@contact');
            Route::get('profile', 'UserController@profile');
            Route::post('profile-update', 'UserController@update');
            Route::post('logout', 'UserController@logout');
            // Route::get('orders', 'OrderController@index');
            // Route::post('orders/create', 'OrderController@store');
            // Route::post('orders/resend', 'OrderController@resend');
            Route::group(['prefix' => 'orders'], function () {
                Route::get('/view/{id}', 'OrderController@show');
                Route::post('/rate', 'OrderController@rate');
                Route::get('/all', 'OrderController@index');
                Route::post('/add', 'OrderController@store');
                Route::post('/add-products', 'OrderController@addProducts');
                Route::get('/create', 'OrderController@create');
                Route::get('/times', 'OrderController@times');
                Route::post('/check-coupon', 'OrderController@checkCoupon');
            });
            Route::group(['prefix' => 'cars'], function () {
                Route::get('/all', 'CarController@index');
                Route::post('/add', 'CarController@store');
                Route::post('/update', 'CarController@update');
                Route::post('/delete', 'CarController@destroy');
            });
            Route::group(['prefix' => 'address'], function(){
                Route::post('/add', 'AddressController@store');
                Route::get('/all', 'AddressController@AllAddresses');
                Route::get('/view/{id}', 'AddressController@GetAddress');
                Route::post('/update/{id}', 'AddressController@UpdateAddress');
                Route::post('/delete/{id}', 'AddressController@DeleteAddress');
            });
            Route::group(['prefix' => 'card'], function(){
                Route::post('/add', 'CardController@store');
                Route::get('/all', 'CardController@AllCards');
                Route::get('/view/{id}', 'CardController@GetCard');
                Route::post('/update/{id}', 'CardController@UpdateCard');
                Route::post('/delete/{id}', 'CardController@DeleteCard');
            });
        });
    });
    Route::group(['prefix' => '/driver'], function() {
        Route::post('/signin', 'DriverController@login'); 
        Route::post('/send-verify-code', 'DriverController@SendVerifySms'); 
        Route::post('/verify-phone', 'DriverController@phoneVerify'); 
        Route::post('/check-driver', 'DriverController@CheckDriver'); 
        Route::post('/forget-password', 'DriverController@sendVerifyForgetPasswordNum'); 
        Route::post('/verify-forget-password', 'DriverController@verifyForgetPassword'); 
        Route::group(['middleware' => 'auth:api-driver'], function() {
            // Route::get('/my-wallet', 'DriverController@wallet');
            Route::get('/my-wallet', 'DriverController@MyWallet');
            Route::post('/send-otp', 'DriverController@generateOtp');
            Route::post('/check-otp', 'DriverController@checkOtp');
            Route::post('/send-otp', 'DriverController@generateOtp');
            Route::post('/check-otp', 'DriverController@checkOtp');
            Route::get('/notifications', 'DriverController@notifications');
            Route::post('/notification-mark-as-readed', 'UserController@notificationReaded');
            Route::post('contact', 'DriverController@contact');
            Route::get('profile', 'DriverController@profile');
            Route::post('profile-update', 'DriverController@update');
            Route::post('logout', 'DriverController@logout');
            // Route::get('orders', 'OrderController@index');
            // Route::post('orders/create', 'OrderController@store');
            // Route::post('orders/resend', 'OrderController@resend');
            Route::group(['prefix' => 'orders'], function () {
                Route::get('/view/{id}', 'DriverOrderController@show');
                Route::post('/all', 'DriverOrderController@index');
                Route::post('/changestatus', 'DriverOrderController@changestatus');
            });
        });
    });
    Route::post('check-location', 'AppInfoController@checkPoint');
    Route::post('get-times', 'AppInfoController@getTimes');
    Route::get('get-times', 'AppInfoController@getTimes');
    Route::get('cities', 'AppInfoController@cities');
    Route::get('brands', 'AppInfoController@brands');
    Route::get('brand-models/{id}', 'AppInfoController@brandmodels');
    Route::get('colors', 'AppInfoController@colors');
    Route::get('/app-info/{type?}', 'AppInfoController@index');
    Route::post('/payment-callback', 'OrderController@Payment');
    Route::get('/test-notify/{type?}', 'NotificationTestController@test');
    Route::get('d-trashed-orders', 'AppInfoController@DeleteTrashedOrders');
});